/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Id {
    private static final Logger LOGGER = LoggerFactory.getLogger(Id.class);
    private static final Pattern PATTERN = Pattern.compile("^[@!$#+]([a-zA-Z0-9._=\\-/]+):(.*)$");

    private Id() {
    }

    public static boolean isId(String id) {
        try {
            Id.validate(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static Matcher validate(String id) {
        if (id == null || id.trim().isEmpty()) {
            String message = "Empty id";
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        Matcher matcher = PATTERN.matcher(id.trim());
        if (!matcher.matches()) {
            String message = String.format("Invalid id: '%s'", id);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        String localpart = matcher.group(1);
        String domain = matcher.group(2);
        LOGGER.trace("localpart: '%s', domain: '%s'", (Object)localpart, (Object)domain);
        try {
            new URI(domain);
        }
        catch (URISyntaxException e) {
            String message = String.format("Invalid domain part: '%s'", domain);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        return matcher;
    }

    public static char sigil(String id) {
        Id.validate(id);
        return id.charAt(0);
    }

    public static String localpart(String id) {
        return Id.validate(id).group(1);
    }

    public static String domain(String id) {
        return Id.validate(id).group(2);
    }

    public static boolean isUserId(String id) {
        return Id.sigil(id) == '@';
    }

    public static boolean isEventId(String id) {
        return Id.sigil(id) == '$';
    }

    public static boolean isRoomId(String id) {
        return Id.sigil(id) == '!';
    }

    public static boolean isAliasId(String id) {
        return Id.sigil(id) == '#';
    }

    public static boolean isGroupId(String id) {
        return Id.sigil(id) == '+';
    }

    public final class Sigil {
        public static final char EVENT = '$';
        public static final char USER = '@';
        public static final char ROOM = '!';
        public static final char ALIAS = '#';
        public static final char GROUP = '+';

        private Sigil() {
        }
    }
}

