/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.event.content;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.nested.RequestedKeyInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="This event type is used to request keys for end-to-end encryption. It is sent as an unencrypted to-device event.")
public class RoomKeyRequestContent
implements EventContent {
    public static final String REQUEST = "request";
    public static final String CANCEL_REQUEST = "cancel_request";
    @Schema(description="Information about the requested key. Required when action is request.")
    private RequestedKeyInfo body;
    @Schema(description="Request action.", required=true, allowableValues={"request, cancel_request"})
    private String action;
    @Schema(name="requesting_device_id", description="ID of the device requesting the key.", required=true)
    @JsonbProperty(value="requesting_device_id")
    private String requestingDeviceId;
    @Schema(name="request_id", description="A random string uniquely identifying the request for a key. If the key is requested multiple times, it should be reused. It should also reused in order to cancel a request.", required=true)
    @JsonbProperty(value="request_id")
    private String requestId;

    public RequestedKeyInfo getBody() {
        return this.body;
    }

    public void setBody(RequestedKeyInfo body) {
        this.body = body;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="requesting_device_id")
    public String getRequestingDeviceId() {
        return this.requestingDeviceId;
    }

    public void setRequestingDeviceId(String requestingDeviceId) {
        this.requestingDeviceId = requestingDeviceId;
    }

    @JsonProperty(value="request_id")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
}

