/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.PushApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.push.NotificationResponse;
import io.github.ma1uta.matrix.client.model.push.PushActions;
import io.github.ma1uta.matrix.client.model.push.PushEnable;
import io.github.ma1uta.matrix.client.model.push.PushRulesResponse;
import io.github.ma1uta.matrix.client.model.push.PushUpdateRequest;
import io.github.ma1uta.matrix.client.model.push.Pusher;
import io.github.ma1uta.matrix.client.model.push.PushersRequest;
import io.github.ma1uta.matrix.client.model.push.PushersResponse;
import io.github.ma1uta.matrix.event.nested.PushRule;
import io.github.ma1uta.matrix.event.nested.Ruleset;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class PushMethods
extends AbstractMethods {
    public PushMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<List<Pusher>> showPushers() {
        return this.factory().get(PushApi.class, "showPushers", this.defaults(), PushersResponse.class).thenApply(PushersResponse::getPushers);
    }

    public CompletableFuture<EmptyResponse> setPushers(PushersRequest request) {
        return this.factory().post(PushApi.class, "setPushers", this.defaults(), request, EmptyResponse.class);
    }

    public CompletableFuture<NotificationResponse> notifications(String from, String only, Long limit) {
        RequestParams params = this.defaults().clone().query("from", from).query("only", only).query("limit", limit);
        return this.factory().get(PushApi.class, "notifications", params, NotificationResponse.class);
    }

    public CompletableFuture<Ruleset> pushRules() {
        return this.factory().get(PushApi.class, "pushRules", new RequestParams(), PushRulesResponse.class).thenApply(PushRulesResponse::getGlobal);
    }

    public CompletableFuture<PushRule> pushRule(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        return this.factory().get(PushApi.class, "pushRule", params, PushRule.class);
    }

    public CompletableFuture<EmptyResponse> deleteRule(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        return this.factory().delete(PushApi.class, "deleteRule", params);
    }

    public CompletableFuture<EmptyResponse> updateRule(String scope, String kind, String ruleId, String before, String after, PushUpdateRequest request) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        if (request.getActions() == null || request.getActions().isEmpty()) {
            throw new NullPointerException("Actions cannot be empty.");
        }
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId).query("before", before).query("after", after);
        return this.factory().put(PushApi.class, "updateRule", params, request, EmptyResponse.class);
    }

    public CompletableFuture<Boolean> getEnabled(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        return this.factory().get(PushApi.class, "getEnabled", params, PushEnable.class).thenApply(PushEnable::getEnabled);
    }

    public CompletableFuture<EmptyResponse> setEnabled(String scope, String kind, String ruleId, boolean enabled) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        PushEnable request = new PushEnable();
        request.setEnabled(Boolean.valueOf(enabled));
        return this.factory().put(PushApi.class, "setEnabled", params, request, EmptyResponse.class);
    }

    public CompletableFuture<List<String>> getActions(String scope, String kind, String ruleId) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().clone().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        return this.factory().get(PushApi.class, "getActions", params, PushActions.class).thenApply(PushActions::getActions);
    }

    public CompletableFuture<EmptyResponse> setActions(String scope, String kind, String ruleId, List<String> actions) {
        Objects.requireNonNull(scope, "Scope cannot be empty.");
        Objects.requireNonNull(kind, "Kind cannot be empty.");
        Objects.requireNonNull(ruleId, "RuleId cannot be empty.");
        RequestParams params = this.defaults().path("scope", scope).path("kind", kind).path("ruleId", ruleId);
        PushActions request = new PushActions();
        request.setActions(actions);
        return this.factory().put(PushApi.class, "setActions", params, request, EmptyResponse.class);
    }
}

