/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.DeviceApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.github.ma1uta.matrix.client.model.device.Device;
import io.github.ma1uta.matrix.client.model.device.DeviceUpdateRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DeviceMethods
extends AbstractMethods {
    public DeviceMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<List<Device>> devices() {
        return this.factory().get(DeviceApi.class, "devices", this.defaults(), DevicesResponse.class).thenApply(DevicesResponse::getDevices);
    }

    public CompletableFuture<Device> device(String deviceId) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        RequestParams params = this.defaults().clone().path("deviceId", deviceId);
        return this.factory().get(DeviceApi.class, "device", params, Device.class);
    }

    public CompletableFuture<EmptyResponse> update(String deviceId, String displayName) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        RequestParams params = this.defaults().clone().path("deviceId", deviceId);
        DeviceUpdateRequest request = new DeviceUpdateRequest();
        request.setDisplayName(displayName);
        return this.factory().put(DeviceApi.class, "updateDevice", params, request, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> delete(AuthenticationData auth) {
        DevicesDeleteRequest request = new DevicesDeleteRequest();
        request.setAuth(auth);
        List<String> devices = Collections.singletonList(this.defaults().getDeviceId());
        request.setDevices(devices);
        return this.factory().post(DeviceApi.class, "deleteDevices", this.defaults(), request, EmptyResponse.class).thenApply(r -> {
            this.defaults().deviceId(null);
            this.defaults().accessToken(null);
            return r;
        });
    }

    public CompletableFuture<EmptyResponse> deleteDevices(DevicesDeleteRequest request) {
        String error = "Devices cannot be empty.";
        Objects.requireNonNull(request.getDevices(), error);
        if (request.getDevices().isEmpty()) {
            throw new NullPointerException(error);
        }
        return this.factory().post(DeviceApi.class, "deleteDevices", this.defaults(), request, EmptyResponse.class).thenApply(r -> {
            if (request.getDevices().contains(this.defaults().getDeviceId())) {
                this.defaults().deviceId(null);
                this.defaults().accessToken(null);
            }
            return r;
        });
    }
}

