/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.AuthApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.auth.Identifier;
import io.github.ma1uta.matrix.client.model.auth.LoginRequest;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.model.auth.LoginType;
import io.github.ma1uta.matrix.client.model.auth.SupportedLoginResponse;
import io.github.ma1uta.matrix.client.model.auth.UserIdentifier;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthMethods
extends AbstractMethods {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthMethods.class);
    private final Function<LoginResponse, LoginResponse> afterLogin;
    private final Function<EmptyResponse, EmptyResponse> afterLogout;

    public AuthMethods(RequestFactory factory, RequestParams defaultParams, Function<LoginResponse, LoginResponse> afterLogin, Function<EmptyResponse, EmptyResponse> afterLogout) {
        super(factory, defaultParams);
        this.afterLogin = afterLogin;
        this.afterLogout = afterLogout;
    }

    protected Function<LoginResponse, LoginResponse> afterLogin() {
        return this.afterLogin;
    }

    protected Function<EmptyResponse, EmptyResponse> afterLogout() {
        return this.afterLogout;
    }

    public CompletableFuture<LoginResponse> login(String login, char[] password) {
        LOGGER.debug("Login with username: ''{}'' and password: ''<redacted>''", (Object)login);
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setType("m.login.password");
        UserIdentifier identifier = new UserIdentifier();
        identifier.setUser(login);
        loginRequest.setIdentifier((Identifier)identifier);
        loginRequest.setPassword(password);
        return this.login(loginRequest);
    }

    public CompletableFuture<LoginResponse> login(LoginRequest loginRequest) {
        Objects.requireNonNull(loginRequest.getType(), "Type cannot be empty.");
        return this.factory().post(AuthApi.class, "login", this.defaults(), loginRequest, LoginResponse.class).thenApply(this.afterLogin());
    }

    public CompletableFuture<EmptyResponse> logout() {
        LOGGER.debug("Logout");
        return this.factory().post(AuthApi.class, "logout", this.defaults(), "", EmptyResponse.class).thenApply(this.afterLogout());
    }

    public CompletableFuture<EmptyResponse> logoutAll() {
        return this.factory().post(AuthApi.class, "logoutAll", this.defaults(), "", EmptyResponse.class).thenApply(this.afterLogout());
    }

    public CompletableFuture<List<LoginType>> loginTypes() {
        return this.factory().get(AuthApi.class, "supportedLoginTypes", this.defaults(), SupportedLoginResponse.class).thenApply(SupportedLoginResponse::getFlows);
    }
}

