/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.EventApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.event.JoinedMembersResponse;
import io.github.ma1uta.matrix.client.model.event.MembersResponse;
import io.github.ma1uta.matrix.client.model.event.RedactRequest;
import io.github.ma1uta.matrix.client.model.event.SendEventResponse;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.message.Notice;
import io.github.ma1uta.matrix.event.message.Text;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.GenericType;

public class EventMethods
extends AbstractMethods {
    public EventMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<Event> event(String roomId, String eventId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventId", eventId);
        return this.factory().get(EventApi.class, "roomEvent", params, Event.class);
    }

    public CompletableFuture<EventContent> eventContent(String roomId, String eventType, String stateKey) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        Objects.requireNonNull(stateKey, "StateKey cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventType", eventType).path("stateKey", stateKey);
        return this.factory().get(EventApi.class, "roomEventWithTypeAndState", params, byte[].class).thenApply(r -> this.factory().deserialize((byte[])r, eventType));
    }

    public CompletableFuture<EventContent> eventContent(String roomId, String eventType) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventType", eventType);
        return this.factory().get(EventApi.class, "roomEventWithType", params, byte[].class).thenApply(r -> this.factory().deserialize((byte[])r, eventType));
    }

    public CompletableFuture<List<Event>> events(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().get(EventApi.class, "roomState", params, new GenericType<List<Event>>(){});
    }

    public CompletableFuture<MembersResponse> members(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().get(EventApi.class, "members", params, MembersResponse.class);
    }

    public CompletableFuture<JoinedMembersResponse> joinedMembers(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId);
        return this.factory().get(EventApi.class, "joinedMembers", params, JoinedMembersResponse.class);
    }

    public CompletableFuture<Page<Event>> messages(String roomId, String from, String to, String dir, Integer limit, String filter) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(from, "From cannot be empty.");
        Objects.requireNonNull(dir, "Dir cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).query("from", from).query("to", to).query("dir", dir).query("filter", filter).query("limit", limit);
        return this.factory().get(EventApi.class, "messages", params, new GenericType<Page<Event>>(){});
    }

    public CompletableFuture<String> sendStateEvent(String roomId, String eventType, String stateKey, Map<String, Object> eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        Objects.requireNonNull(stateKey, "StateKey cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventType", eventType).path("stateKey", stateKey);
        return this.factory().put(EventApi.class, "sendEventWithTypeAndState", params, eventContent, SendEventResponse.class).thenApply(SendEventResponse::getEventId);
    }

    public CompletableFuture<String> sendStateEvent(String roomId, String eventType, Map<String, Object> eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventType", eventType);
        return this.factory().put(EventApi.class, "sendEventWithType", params, eventContent, SendEventResponse.class).thenApply(SendEventResponse::getEventId);
    }

    public CompletableFuture<String> sendEvent(String roomId, String eventType, EventContent eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventType", eventType).path("txnId", Long.toString(System.currentTimeMillis()));
        return this.factory().put(EventApi.class, "sendEvent", params, eventContent, SendEventResponse.class).thenApply(SendEventResponse::getEventId);
    }

    public CompletableFuture<String> redact(String roomId, String eventId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        RequestParams params = this.defaults().clone().path("roomId", roomId).path("eventId", eventId).path("txnId", Long.toString(System.currentTimeMillis()));
        RedactRequest request = new RedactRequest();
        request.setReason(reason);
        return this.factory().put(EventApi.class, "redact", params, request, SendEventResponse.class).thenApply(SendEventResponse::getEventId);
    }

    public CompletableFuture<String> sendMessage(String roomId, String text) {
        return this.sendFormattedMessage(roomId, text, null);
    }

    public CompletableFuture<String> sendNotice(String roomId, String text) {
        return this.sendFormattedNotice(roomId, text, null);
    }

    public CompletableFuture<String> sendFormattedMessage(String roomId, String text, String formattedText) {
        Text payload = new Text();
        payload.setBody(text);
        payload.setFormattedBody(formattedText);
        if (formattedText != null) {
            payload.setFormat("org.matrix.custom.html");
        }
        return this.sendEvent(roomId, "m.room.message", (EventContent)payload);
    }

    public CompletableFuture<String> sendFormattedNotice(String roomId, String text, String formattedText) {
        Notice payload = new Notice();
        payload.setBody(text);
        payload.setFormattedBody(formattedText);
        if (formattedText != null) {
            payload.setFormat("org.matrix.custom.html");
        }
        return this.sendEvent(roomId, "m.room.message", (EventContent)payload);
    }
}

