/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.rest.blocked;

import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.NewVersion;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.ReplacementRoom;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomResolveResponse;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.github.ma1uta.matrix.client.model.room.UnbanRequest;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RoomApi {
    @POST
    @Path(value="/createRoom")
    public RoomId create(CreateRoomRequest var1);

    @PUT
    @Path(value="/directory/room/{roomAlias}")
    public EmptyResponse createAlias(@PathParam(value="roomAlias") String var1, RoomId var2);

    @GET
    @Path(value="/directory/room/{roomAlias}")
    public RoomResolveResponse resolveAlias(@PathParam(value="roomAlias") String var1);

    @DELETE
    @Path(value="/directory/room/{roomAlias}")
    public EmptyResponse deleteAlias(@PathParam(value="roomAlias") String var1);

    @GET
    @Path(value="/joined_rooms")
    public JoinedRoomsResponse joinedRooms();

    @POST
    @Path(value="/rooms/{roomId}/invite")
    public EmptyResponse invite(@PathParam(value="roomId") String var1, InviteRequest var2);

    @POST
    @Path(value="/rooms/{roomId}/join")
    public RoomId joinById(@PathParam(value="roomId") String var1, JoinRequest var2);

    @POST
    @Path(value="/join/{roomIdOrAlias}")
    public RoomId joinByIdOrAlias(@PathParam(value="roomIdOrAlias") String var1, @QueryParam(value="server_name") List<String> var2, JoinRequest var3);

    @POST
    @Path(value="/rooms/{roomId}/leave")
    public EmptyResponse leave(@PathParam(value="roomId") String var1);

    @POST
    @Path(value="/rooms/{roomId}/forget")
    public EmptyResponse forget(@PathParam(value="roomId") String var1);

    @POST
    @Path(value="/rooms/{roomId}/kick")
    public EmptyResponse kick(@PathParam(value="roomId") String var1, KickRequest var2);

    @POST
    @Path(value="/rooms/{roomId}/ban")
    public EmptyResponse ban(@PathParam(value="roomId") String var1, KickRequest var2);

    @POST
    @Path(value="/rooms/{roomId}/unban")
    public EmptyResponse unban(@PathParam(value="roomId") String var1, UnbanRequest var2);

    @GET
    @Path(value="/directory/list/room/{roomId}")
    public RoomVisibility getVisibility(@PathParam(value="roomId") String var1);

    @PUT
    @Path(value="/directory/list/room/{roomId}")
    public EmptyResponse setVisibility(@PathParam(value="roomId") String var1, RoomVisibility var2);

    @GET
    @Path(value="/publicRooms")
    public PublicRoomsResponse showPublicRooms(@QueryParam(value="limit") Long var1, @QueryParam(value="since") String var2, @QueryParam(value="server") String var3);

    @POST
    @Path(value="/publicRooms")
    public PublicRoomsResponse searchPublicRooms(@QueryParam(value="server") String var1, PublicRoomsRequest var2);

    @POST
    @Path(value="/rooms/{roomId}/upgrade")
    public ReplacementRoom upgrade(@PathParam(value="roomId") String var1, NewVersion var2);
}

