/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.rest.async;

import io.github.ma1uta.matrix.client.model.event.JoinedMembersResponse;
import io.github.ma1uta.matrix.client.model.event.MembersResponse;
import io.github.ma1uta.matrix.client.model.event.RedactRequest;
import io.github.ma1uta.matrix.client.model.event.SendEventResponse;
import io.github.ma1uta.matrix.common.Page;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.EventContent;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/_matrix/client/r0/rooms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface EventApi {
    @GET
    @Path(value="/{roomId}/event/{eventId}")
    public CompletionStage<Event> roomEvent(@PathParam(value="roomId") String var1, @PathParam(value="eventId") String var2);

    @GET
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public CompletionStage<byte[]> roomEventWithTypeAndState(@PathParam(value="roomId") String var1, @PathParam(value="eventType") String var2, @PathParam(value="stateKey") String var3);

    @GET
    @Path(value="/{roomId}/state")
    public CompletionStage<List<Event>> roomState(@PathParam(value="roomId") String var1);

    @GET
    @Path(value="/{roomId}/members")
    public CompletionStage<MembersResponse> members(@PathParam(value="roomId") String var1);

    @GET
    @Path(value="/{roomId}/joined_members")
    public CompletionStage<JoinedMembersResponse> joinedMembers(@PathParam(value="roomId") String var1);

    @GET
    @Path(value="/{roomId}/messages")
    public CompletionStage<Page<Event>> messages(@PathParam(value="roomId") String var1, @QueryParam(value="from") String var2, @QueryParam(value="to") String var3, @QueryParam(value="dir") String var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="filter") String var6);

    @PUT
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public CompletionStage<SendEventResponse> sendStateEvent(@PathParam(value="roomId") String var1, @PathParam(value="eventType") String var2, @PathParam(value="stateKey") String var3, EventContent var4);

    @PUT
    @Path(value="/{roomId}/state/{eventType}")
    public CompletionStage<SendEventResponse> sendStateEvent(@PathParam(value="roomId") String var1, @PathParam(value="eventType") String var2, EventContent var3);

    @PUT
    @Path(value="/{roomId}/send/{eventType}/{txnId}")
    public CompletionStage<SendEventResponse> sendEvent(@PathParam(value="roomId") String var1, @PathParam(value="eventType") String var2, @PathParam(value="txnId") String var3, EventContent var4);

    @PUT
    @Path(value="/{roomId}/redact/{eventId}/{txnId}")
    public CompletionStage<SendEventResponse> redact(@PathParam(value="roomId") String var1, @PathParam(value="eventId") String var2, @PathParam(value="txnId") String var3, RedactRequest var4);
}

