/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.tag.Tags;
import io.github.ma1uta.matrix.client.rest.blocked.TagApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import io.github.ma1uta.matrix.event.nested.TagInfo;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class TagMethods {
    private final TagApi tagApi;
    private final ConnectionInfo connectionInfo;

    public TagMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.tagApi = (TagApi)restClientBuilder.build(TagApi.class);
        this.connectionInfo = connectionInfo;
    }

    public Tags show(String roomId) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.tagApi.showTags(userId, roomId);
    }

    public EmptyResponse add(String roomId, String tag, Long order) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagInfo cannot be empty.");
        TagInfo tagInfo = new TagInfo();
        tagInfo.setOrder(order);
        return this.tagApi.addTag(userId, roomId, tag, tagInfo);
    }

    public EmptyResponse delete(String roomId, String tag) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagContent cannot be empty.");
        return this.tagApi.deleteTag(userId, roomId, tag);
    }
}

