/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.NewVersion;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.ReplacementRoom;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomResolveResponse;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.github.ma1uta.matrix.client.model.room.UnbanRequest;
import io.github.ma1uta.matrix.client.rest.blocked.RoomApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class RoomMethods {
    private final RoomApi roomApi;

    public RoomMethods(RestClientBuilder restClientBuilder) {
        this.roomApi = (RoomApi)restClientBuilder.build(RoomApi.class);
    }

    public RoomId create(CreateRoomRequest request) {
        return this.roomApi.create(request);
    }

    public EmptyResponse createAlias(RoomId roomId, String alias) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.createAlias(alias, roomId);
    }

    public RoomResolveResponse resolveAlias(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.resolveAlias(alias);
    }

    public EmptyResponse delete(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.deleteAlias(alias);
    }

    public JoinedRoomsResponse joinedRooms() {
        return this.roomApi.joinedRooms();
    }

    public EmptyResponse invite(String roomId, InviteRequest request) {
        boolean emptyThirdPartyId;
        boolean emptyRoomId = roomId == null;
        boolean bl = emptyThirdPartyId = request == null || request.getIdServer() == null || request.getAddress() == null || request.getMedium() == null || request.getUserId() == null;
        if (emptyRoomId && emptyThirdPartyId) {
            throw new NullPointerException("Either roomId or third party request should be specified");
        }
        return this.roomApi.invite(roomId, request);
    }

    public RoomId joinById(String roomId, JoinRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.joinById(roomId, request);
    }

    public RoomId joinByIdOrAlias(String idOrAlias, List<String> serverNames, JoinRequest joinRequest) {
        Objects.requireNonNull(idOrAlias, "IdOrAlias cannot be empty.");
        return this.roomApi.joinByIdOrAlias(idOrAlias, serverNames, joinRequest);
    }

    public EmptyResponse leave(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.leave(roomId);
    }

    public EmptyResponse forget(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.forget(roomId);
    }

    public EmptyResponse kick(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.roomApi.kick(roomId, request);
    }

    public EmptyResponse ban(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.roomApi.ban(roomId, request);
    }

    public EmptyResponse unban(String roomId, String userId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        UnbanRequest request = new UnbanRequest();
        request.setUserId(userId);
        return this.roomApi.unban(roomId, request);
    }

    public RoomVisibility getVisibility(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.getVisibility(roomId);
    }

    public EmptyResponse setVisibility(String roomId, String visibility) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RoomVisibility request = new RoomVisibility();
        request.setVisibility(visibility);
        return this.roomApi.setVisibility(roomId, request);
    }

    public PublicRoomsResponse showPublicRooms(Long limit, String since, String server) {
        return this.roomApi.showPublicRooms(limit, since, server);
    }

    public PublicRoomsResponse searchPublicRooms(String server, PublicRoomsRequest request) {
        return this.roomApi.searchPublicRooms(server, request);
    }

    public ReplacementRoom upgrade(String roomId, String newVersion) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(newVersion, "New version cannot be empty.");
        NewVersion request = new NewVersion();
        request.setNewVersion(newVersion);
        return this.roomApi.upgrade(roomId, request);
    }
}

