/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.rest.blocked.ClientConfigApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ClientConfigMethods {
    private final ClientConfigApi clientConfigApi;
    private final ConnectionInfo connectionInfo;

    public ClientConfigMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.clientConfigApi = (ClientConfigApi)restClientBuilder.build(ClientConfigApi.class);
        this.connectionInfo = connectionInfo;
    }

    public EmptyResponse addConfig(String type, Map<String, Object> accountData) {
        Objects.requireNonNull(type, "Type cannot be empty.");
        Objects.requireNonNull(this.connectionInfo.getUserId(), "UserId cannot be empty.");
        return this.clientConfigApi.addConfig(this.connectionInfo.getUserId(), type, accountData);
    }

    public Map getConfig(String type) {
        Objects.requireNonNull(type, "Type cannot be empty.");
        Objects.requireNonNull(this.connectionInfo.getUserId(), "UserId cannot be empty.");
        return this.clientConfigApi.getConfig(this.connectionInfo.getUserId(), type);
    }

    public EmptyResponse addRoomConfig(String roomId, String type, Map<String, Object> accountData) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(type, "Type cannot be empty");
        Objects.requireNonNull(this.connectionInfo.getUserId(), "UserId cannot be empty");
        return this.clientConfigApi.addRoomConfig(this.connectionInfo.getUserId(), roomId, type, accountData);
    }

    public Map getRoomConfig(String roomId, String type) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(type, "Type cannot be empty");
        Objects.requireNonNull(this.connectionInfo.getUserId(), "UserId cannot be empty");
        return this.clientConfigApi.getRoomConfig(this.connectionInfo.getUserId(), roomId, type);
    }
}

