/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.profile.AvatarUrl;
import io.github.ma1uta.matrix.client.model.profile.DisplayName;
import io.github.ma1uta.matrix.client.model.profile.Profile;
import io.github.ma1uta.matrix.client.rest.blocked.ProfileApi;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ProfileMethods {
    private final ProfileApi profileApi;
    private final ConnectionInfo connectionInfo;

    public ProfileMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.profileApi = (ProfileApi)restClientBuilder.build(ProfileApi.class);
        this.connectionInfo = connectionInfo;
    }

    public EmptyResponse setDisplayName(String displayName) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        DisplayName request = new DisplayName();
        request.setDisplayName(displayName);
        return this.profileApi.setDisplayName(userId, request);
    }

    public DisplayName showDisplayName(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.showDisplayName(userId);
    }

    public EmptyResponse setAvaterUrl(String avatarUrl) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        AvatarUrl request = new AvatarUrl();
        request.setAvatarUrl(avatarUrl);
        return this.profileApi.setAvatarUrl(userId, request);
    }

    public AvatarUrl showAvatarUrl(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.showAvatarUrl(userId);
    }

    public Profile profile(String userId) {
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.profileApi.profile(userId);
    }
}

