/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.filter.FilterData;
import io.github.ma1uta.matrix.client.model.filter.FilterResponse;
import io.github.ma1uta.matrix.client.rest.FilterApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class FilterMethods {
    private final FilterApi filterApi;
    private final ConnectionInfo connectionInfo;

    public FilterMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.filterApi = (FilterApi)restClientBuilder.build(FilterApi.class);
        this.connectionInfo = connectionInfo;
    }

    public CompletableFuture<FilterResponse> uploadFilter(FilterData filter) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        return this.filterApi.uploadFilter(userId, filter).toCompletableFuture();
    }

    public CompletableFuture<FilterData> getFilter(String filterId) {
        String userId = this.connectionInfo.getUserId();
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(filterId, "FilterId cannot be empty.");
        return this.filterApi.getFilter(userId, filterId).toCompletableFuture();
    }
}

