/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.filter;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.client.filter.StreamHelper;
import io.github.ma1uta.matrix.impl.Deserializer;
import io.github.ma1uta.matrix.impl.exception.MatrixException;
import io.github.ma1uta.matrix.impl.exception.RateLimitedException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorFilter
implements ClientResponseFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorFilter.class);
    private volatile Deserializer deserializer;
    public static final int RATE_LIMIT_RESPONSE_STATUS = 429;

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        int status = responseContext.getStatus();
        LOGGER.trace("Response status: {}", (Object)status);
        switch (status) {
            case 200: {
                LOGGER.trace("OK.");
                break;
            }
            case 429: {
                this.throwRateLimitException(responseContext);
                return;
            }
            default: {
                this.throwException(responseContext, status);
            }
        }
    }

    private void throwRateLimitException(ClientResponseContext responseContext) throws IOException {
        byte[] response = StreamHelper.toByteArray(responseContext.getEntityStream());
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.error("Response: {}", (Object)new String(response, StandardCharsets.UTF_8));
            }
            RateLimitedErrorResponse rateLimitedResponse = (RateLimitedErrorResponse)this.getDeserializer().deserialize(response, RateLimitedErrorResponse.class);
            LOGGER.error("Rate limited response, error code: '{}', error: '{}', retry after {} milliseconds", new Object[]{rateLimitedResponse.getErrcode(), rateLimitedResponse.getError(), rateLimitedResponse.getRetryAfterMs()});
            throw new RateLimitedException(rateLimitedResponse.getErrcode(), rateLimitedResponse.getError(), rateLimitedResponse.getRetryAfterMs());
        }
        catch (Exception e) {
            LOGGER.error("Response: {}", (Object)new String(response, StandardCharsets.UTF_8));
            LOGGER.error("Unable to parse response content", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void throwException(ClientResponseContext responseContext, int status) throws IOException {
        if (0 == responseContext.getLength()) {
            String message = String.format("Response status: %s, empty content", status);
            LOGGER.error(message);
            throw new RuntimeException(message);
        }
        byte[] response = StreamHelper.toByteArray(responseContext.getEntityStream());
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.error("Response: {}", (Object)new String(response, StandardCharsets.UTF_8));
            }
            ErrorResponse errorResponse = (ErrorResponse)this.getDeserializer().deserialize(response, ErrorResponse.class);
            LOGGER.error("Error response, error code: '{}', error: '{}'", (Object)errorResponse.getErrcode(), (Object)errorResponse.getError());
            throw new MatrixException(errorResponse.getErrcode(), errorResponse.getError());
        }
        catch (Exception e) {
            LOGGER.error("Response: {}", (Object)new String(response, StandardCharsets.UTF_8));
            LOGGER.error("Unable to parse response content", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Deserializer getDeserializer() {
        if (this.deserializer == null) {
            ErrorFilter errorFilter = this;
            synchronized (errorFilter) {
                if (this.deserializer == null) {
                    Iterator<Deserializer> iterator = ServiceLoader.load(Deserializer.class).iterator();
                    if (iterator.hasNext()) {
                        this.deserializer = iterator.next();
                    } else {
                        throw new IllegalStateException("Unable to found the object serializer. Check jackson-support or jsonb-support packages included.");
                    }
                }
            }
        }
        return this.deserializer;
    }
}

