/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.push.NotificationResponse;
import io.github.ma1uta.matrix.client.model.push.PushActions;
import io.github.ma1uta.matrix.client.model.push.PushEnable;
import io.github.ma1uta.matrix.client.model.push.PushRule;
import io.github.ma1uta.matrix.client.model.push.PushRulesResponse;
import io.github.ma1uta.matrix.client.model.push.PushUpdateRequest;
import io.github.ma1uta.matrix.client.model.push.PushersRequest;
import io.github.ma1uta.matrix.client.model.push.PushersResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface PushApi {
    @Operation(summary="Gets all currently active pushers for the authenticated user.", responses={@ApiResponse(responseCode="200", description="The pushers for this user.", content={@Content(schema=@Schema(implementation=PushersResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/pushers")
    public void showPushers(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="This endpoint allows the creation, modification and deletion of pushers for this user ID. The behaviour of this endpoint varies depending on the values in the JSON body.", responses={@ApiResponse(responseCode="200", description="The pusher was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="400", description="One or more of the pusher values were invalid.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/pushers/set")
    public void setPushers(@RequestBody(description="JSON body request") PushersRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @Operation(summary="This API is used to paginate through the list of events that the user has been, or would have been notified about.", responses={@ApiResponse(responseCode="200", description="A batch of events is being returned.", content={@Content(schema=@Schema(implementation=NotificationResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/notifications")
    public void notifications(@Parameter(description="Pagination token given to retrieve the next set of events.") @QueryParam(value="from") String var1, @Parameter(description="Allows basic filtering of events returned.") @QueryParam(value="only") String var2, @Parameter(description="Limit on the number of events to return in this request.") @QueryParam(value="limit") Long var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Retrieve all push rulesets for this user. Clients can \"drill-down]\"on the rulesets by suffixing a scope to this path e.g. /pushrules/global/. This will return a subset of this data under the specified key e.g. the global key.", responses={@ApiResponse(responseCode="200", description="All the push rulesets for this user.", content={@Content(schema=@Schema(implementation=PushRulesResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/pushrules")
    public void pushRules(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    @Operation(summary="Retrieve a single specified push rule.", responses={@ApiResponse(responseCode="200", description="The specific push rule. This will also include keys specific to the rule itself such as the rule's actions and conditions if set.", content={@Content(schema=@Schema(implementation=PushRule.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void pushRule(@Parameter(description="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This endpoint removes the push rule defined in the path.", responses={@ApiResponse(responseCode="200", description="The push rule was deleted.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @DELETE
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void deleteRule(@Parameter(description="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This endpoint allows the creation, modification and deletion of pushers for this user ID. The behaviour of this endpoint varies depending on the values in the JSON body.", responses={@ApiResponse(responseCode="200", description="The pusher was set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))}), @ApiResponse(responseCode="400", description="There was a problem configuring this push rule.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}")
    public void updateRule(@Parameter(description="Global to specify global rules.", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Parameter(description="Use 'before' with a rule_id as its value to make the new rule the next-most important rule with respect to the given user defined rule. It is not possible to add a rule relative to a predefined server rule.") @QueryParam(value="before") String var4, @Parameter(description="This makes the new rule the next-less important rule relative to the given user defined rule. It is not possible to add a rule relative to a predefined server rule.") @QueryParam(value="after") String var5, @RequestBody(description="JSON body request.") PushUpdateRequest var6, @Context UriInfo var7, @Context HttpHeaders var8, @Suspended AsyncResponse var9, @Context SecurityContext var10);

    @Operation(summary="This endpoint gets whether the specified push rule is enabled.", responses={@ApiResponse(responseCode="200", description="Whether the push rule is enabled.", content={@Content(schema=@Schema(implementation=PushEnable.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/enabled")
    public void getEnabled(@Parameter(description="Either global or device/&lt;profile_tag&gt; to specify global rules or device rules for the given profile_tag.", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This endpoint allows clients to enable or disable the specified push rule.", responses={@ApiResponse(responseCode="200", description="The push rule was enabled or disabled.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @PUT
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/enabled")
    public void setEnabled(@Parameter(description="Global to specify global rules", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @RequestBody(description="JSON body request.") PushEnable var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    @Operation(summary="This endpoint get the actions for the specified push rule.", responses={@ApiResponse(responseCode="200", description="The actions for this push rule.", content={@Content(schema=@Schema(implementation=PushActions.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/actions")
    public void getActions(@Parameter(description="Either global or device/&lt;profile_tag&gt; to specify global rules or device rules for the given profile_tag.", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="This endpoint allows clients to change the actions of a push rule. This can be used to change the actions of builtin rules.", responses={@ApiResponse(responseCode="200", description="The actions for the push rule were set.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @PUT
    @Secured
    @Path(value="/pushrules/{scope}/{kind}/{ruleId}/actions")
    public void setActions(@Parameter(description="Global to specify global rules", required=true) @PathParam(value="scope") String var1, @Parameter(description="The kind of rule.", required=true, schema=@Schema(allowableValues={"override", "underride", "sender", "room", "content"})) @PathParam(value="kind") String var2, @Parameter(description="The identifier for the rule.", required=true) @PathParam(value="ruleId") String var3, @RequestBody(description="JSON body request.") PushActions var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7, @Context SecurityContext var8);

    public static class Condition {
        public static final String EVENT_MATCH = "event_match";
        public static final String CONTAINS_DISPLAY_NAME = "contains_display_name";
        public static final String ROOM_MEMBER_COUNT = "room_member_count";
        public static final String SENDER_NOTIFICATION_PERMISSION = "sender_notification_permission";

        protected Condition() {
        }
    }

    public static class Rule {
        public static final String MASTER = ".m.rule.master";
        public static final String SUPPRESS_NOTICES = ".m.rule.suppress_notices";
        public static final String INVITE_FOR_ME = ".m.rule.invite_for_me";
        public static final String MEMBER_EVENT = ".m.rule.member_event";
        public static final String CONTAINS_DISPLAY_NAME = ".m.rule.contains_display_name";
        public static final String ROOM_NOTIF = ".m.rule.roomnotif";
        public static final String CONTAINS_USER_NAME = ".m.rule.contains_user_name";
        public static final String CALL = ".m.rule.call";
        public static final String ENCRYPTED_ROOM_ONE_TO_ONE = ".m.rule.encrypted_room_one_to_one";
        public static final String ROOM_ONE_TO_ONE = ".m.rule.room_one_to_one";
        public static final String MESSAGE = ".m.rule.message";
        public static final String ENCRYPTED = ".m.rule.encrypted";

        protected Rule() {
        }
    }

    public static class Tweak {
        public static final String SOUND = "sound";
        public static final String HIGHLIGHT = "highlight";

        protected Tweak() {
        }
    }

    public static class Actions {
        public static final String NOTIFY = "notify";
        public static final String DONT_NOTIFY = "dont_notify";
        public static final String COALESCE = "coalesce";
        public static final String SET_TWEAK = "set_tweak";

        protected Actions() {
        }
    }

    public static class Kind {
        public static final String OVERRIDE = "override";
        public static final String UNDERRIDE = "underride";
        public static final String SENDER = "sender";
        public static final String ROOM = "room";
        public static final String CONTENT = "content";

        protected Kind() {
        }
    }
}

