/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.filter.FilterData;
import io.github.ma1uta.matrix.client.model.filter.FilterResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface FilterApi {
    @Operation(summary="Uploads a new filter definition to the homeserver.", description="Returns a filter ID that may be used in future requests to restrict which events are returned to the client.", responses={@ApiResponse(responseCode="200", description="The filter was created.", content={@Content(schema=@Schema(implementation=FilterResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @POST
    @Secured
    @Path(value="/{userId}/filter")
    default public void uploadFilter(@Parameter(description="The id of the user uploading the filter. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String userId, @RequestBody(description="JSON body parameters") FilterData filterData, @Context UriInfo uriInfo, @Context HttpHeaders httpHeaders, @Suspended AsyncResponse asyncResponse, @Context SecurityContext securityContext) {
    }

    @Operation(summary="Download a filter.", responses={@ApiResponse(responseCode="200", description="The filter definition.", content={@Content(schema=@Schema(implementation=FilterData.class))}), @ApiResponse(responseCode="404", description="Unknown filter.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")})
    @GET
    @Secured
    @Path(value="/{userId}/filter/{filterId}")
    public void getFilter(@Parameter(description="The user ID to download a filter for.", required=true) @PathParam(value="userId") String var1, @Parameter(description="The filter ID to download.", required=true) @PathParam(value="filterId") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);
}

