/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.openid.OpenIdResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface OpenIdApi {
    @Operation(summary="Gets an OpenID token object that the requester may supply to another service to verify their identity in Matrix.", description="The generated token is only valid for exchanging for user information from the federation API for OpenID. The access token generated is only valid for the OpenID API. It cannot be used to request another OpenID access token or call /sync, for example.", responses={@ApiResponse(responseCode="200", description="OpenID token information. This response is nearly compatible with the response documented in the OpenID 1.0 Specification with the only difference being the lack of an id_token. Instead, the Matrix homeserver's name is provided.", content={@Content(schema=@Schema(implementation=OpenIdResponse.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"OpenID"})
    @POST
    @Secured
    @RateLimit
    @Path(value="/user/{userId}/openid/request_token")
    public void requestToken(@Parameter(description="The user to request and OpenID token for. Should be the user who is authenticated for the request.", required=true) @PathParam(value="userId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

