/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.typing.TypingRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Typing", description="When a client receives an m.typing event, it MUST use the user ID list to REPLACE its knowledge of every user who is currently typing. The reason for this is that the server does not remember users who are not currently typing as that list gets big quickly. The client should mark as not typing any user ID who is not in that list.")
@Path(value="/_matrix/client/r0/rooms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface TypingApi {
    @ApiOperation(value="This tells the server that the user is typing for the next N milliseconds where N is the value specified in the timeout key. Alternatively, if typing is false, it tells the server that the user has stopped typing.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The new typing state was set."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{roomId}/typing/{userId}")
    public EmptyResponse typing(@ApiParam(value="The user who has started to type.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The room in which the user is typing.", required=true) @PathParam(value="userId") String var2, @ApiParam(value="JSON body request.") TypingRequest var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5, @Context SecurityContext var6);
}

