/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Api(value="FallbackAuthentication", description="If a client does not recognize any or all login flows it can use the fallback login API.")
@Path(value="/_matrix")
@Produces(value={"text/html"})
public interface FallbackAuthApi {
    @ApiOperation(value="Fallback login.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Login page for the fallback login.")})
    @GET
    @Path(value="/static/client/login")
    public String staticLogin();

    @ApiOperation(value="Fallback login endpoint", notes="If a client does not know how to handle a given login type, it can direct the user to a web browser with the URL of a fallback page which will allow the user to complete that login step out-of-band in their web browser.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="n HTML page which can perform this authentication stage. This page must use the following JavaScript when the authentication has been completed.")})
    @GET
    @Path(value="/client/r0/auth/{auth}/fallback/web")
    public String auth(@ApiParam(value="The type name of the stage it is attempting.") @PathParam(value="auth") String var1, @ApiParam(value="the ID of the session given by the homeserver.") @QueryParam(value="session") String var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4);
}

