/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.account.AvailableResponse;
import io.github.ma1uta.matrix.client.model.account.DeactivateRequest;
import io.github.ma1uta.matrix.client.model.account.PasswordRequest;
import io.github.ma1uta.matrix.client.model.account.RegisterRequest;
import io.github.ma1uta.matrix.client.model.account.RequestToken;
import io.github.ma1uta.matrix.client.model.account.ThreePidRequest;
import io.github.ma1uta.matrix.client.model.account.ThreePidResponse;
import io.github.ma1uta.matrix.client.model.account.WhoamiResponse;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Account", description="Account registration and management")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface AccountApi {
    @ApiOperation(value="Register for an account on this homeserver.", response=LoginResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The account has been registered"), @ApiResponse(code=400, message="Part of the request was invalid."), @ApiResponse(code=401, message="The homeserver requires additional authentication information."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Path(value="/register")
    public LoginResponse register(@ApiParam(value="The kind of account to register.", defaultValue="user", allowableValues="['guest', 'user']") @QueryParam(value="kind") String var1, @ApiParam(value="JSON body request") RegisterRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4);

    @ApiOperation(value="Request token.", notes="Proxies the identity server API validate/email/requestToken, but first checks that the given email address is not already associated with an account on this Home Server. Note that, for consistency, this API takes JSON objects, though the Identity Server API takes x-www-form-urlencoded parameters. See the Identity Server API for further information.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An email has been sent to the specified address."), @ApiResponse(code=400, message="Part of the request was invalid.")})
    @POST
    @Path(value="/register/email/requestToken")
    public EmptyResponse requestToken(@ApiParam(value="request") RequestToken var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3);

    @ApiOperation(value="Changes the password for an account on this homeserver.", notes="This API endpoint uses the User-Interactive Authentication API. An access token should be submitted to this endpoint if the client has an active session. The homeserver may change the flows available depending on whether a valid access token is provided.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The password has been changed."), @ApiResponse(code=401, message="The homeserver requires additional authentication information."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/account/password")
    public EmptyResponse password(@ApiParam(value="password") PasswordRequest var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Proxies the identity server API validate/email/requestToken, but first checks that the given email address is associated with an account on this Home Server.", notes="This API should be used to request validation tokens when authenticating for the account/password endpoint. This API's parameters and response are identical to that of the HS API /register/email/requestToken except that M_THREEPID_NOT_FOUND may be returned if no account matching the given email address could be found. The server may instead send an email to the given address prompting the user to create an account. M_THREEPID_IN_USE may not be returned.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An email was sent to the given address")})
    @POST
    @Path(value="/account/password/email/requestToken")
    public EmptyResponse passwordRequestToken(@Context HttpServletRequest var1, @Context HttpServletResponse var2);

    @ApiOperation(value="Deactivate the user's account, removing all ability for the user to login again.", notes="This API endpoint uses the User-Interactive Authentication API.An access token should be submitted to this endpoint if the client has an active session.The homeserver may change the flows available depending on whether a valid access token is provided.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The account has been deactivated."), @ApiResponse(code=401, message="The homeserver requires additional authentication information."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Secured
    @Path(value="/account/deactivate")
    public EmptyResponse deactivate(@ApiParam(value="request") DeactivateRequest var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Checks to see if a username is available, and valid, for the server.", notes="he server should check to ensure that, at the time of the request, the username requested is available for use.This includes verifying that an application service has not claimed the username and that the username fits the server'sdesired requirements (for example, a server could dictate that it does not permit usernames with underscores).Matrix clients may wish to use this API prior to attempting registration, however the clients must also be awarethat using this API does not normally reserve the username. This can mean that the username becomes unavailablebetween checking its availability and attempting to register it.", response=AvailableResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The username is available."), @ApiResponse(code=400, message="Part of the request was invalid or the username is not available"), @ApiResponse(code=429, message="This request was rate-limited")})
    @GET
    @RateLimit
    @Path(value="/register/available")
    public AvailableResponse available(@ApiParam(value="The username to check the availability of", required=true) @QueryParam(value="username") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3);

    @ApiOperation(value="Gets a list of the third party identifiers that the homeserver has associated with the user's account", notes="This is not the same as the list of third party identifiers bound to the user's Matrix ID in Identity Servers. Identifiers in this list may be used by the homeserver as, for example, identifiers that it will accept to reset the user's account password.", response=ThreePidResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The lookup was successful")})
    @GET
    @Secured
    @Path(value="/account/3pid")
    public ThreePidResponse showThreePid(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="Adds contact information to the user's account", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The addition was successful."), @ApiResponse(code=403, message="The credentials could not be verified with the identity server.")})
    @POST
    @Secured
    @Path(value="/account/3pid")
    public EmptyResponse updateThreePid(@ApiParam(value="new contact information") ThreePidRequest var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Proxies the identity server API validate/email/requestToken", notes="roxies the identity server API validate/email/requestToken, but first checks that the given email address is not already associated with an account on this Home Server. This API should be used to request validation tokens when adding an email address to an account. This API's parameters and response is identical to that of the HS API /register/email/requestToken endpoint.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An email was sent to the given address")})
    @POST
    @Path(value="/account/3pid/email/requestToken")
    public EmptyResponse threePidRequestToken(@Context HttpServletRequest var1, @Context HttpServletResponse var2);

    @ApiOperation(value="Gets information about the owner of a given access token", notes="Note that, as with the rest of the Client-Server API, Application Services may masquerade as users within their namespace by giving a user_id query parameter. In this situation, the server should verify that the given user_id is registered by the appservice, and return it in the response body.", response=WhoamiResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The token belongs to a known user"), @ApiResponse(code=401, message="The token is not recognised."), @ApiResponse(code=403, message="The appservice cannot masquerade as the user or has not registered them."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Secured
    @Path(value="/account/whoami")
    public WhoamiResponse whoami(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    public static class RegisterType {
        public static final String GUEST = "guest";
        public static final String USER = "user";

        protected RegisterType() {
        }
    }
}

