/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.common.PusherData;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Pusher. A pusher is a worker on the homeserver that manages the sending of HTTP notifications for a user. A user can have multiple pushers: one per device.")
public class Pusher {
    @Schema(description="This is a unique identifier for this pusher. See /set for more detail. Max length, 512 bytes.")
    private String pushkey;
    @Schema(description="The kind of pusher. \"http\" is a pusher that sends HTTP pokes.")
    private String kind;
    @Schema(description="This is a reverse-DNS style identifier for the application. Max length, 64 chars.")
    @JsonbProperty(value="app_id")
    private String appId;
    @Schema(description="A string that will allow the user to identify what application owns this pusher.")
    @JsonbProperty(value="app_display_name")
    private String appDisplayName;
    @Schema(description="A string that will allow the user to identify what device owns this pusher.")
    @JsonbProperty(value="device_display_name")
    private String deviceDisplayName;
    @Schema(description="This string determines which set of device specific rules this pusher executes.")
    @JsonbProperty(value="profile_tag")
    private String profileTag;
    @Schema(description="The preferred language for receiving notifications (e.g. 'en' or 'en-US')")
    private String lang;
    @Schema(description="A dictionary of information for the pusher implementation itself.")
    private PusherData data;

    public String getPushkey() {
        return this.pushkey;
    }

    public void setPushkey(String pushkey) {
        this.pushkey = pushkey;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="app_id")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @JsonProperty(value="app_display_name")
    public String getAppDisplayName() {
        return this.appDisplayName;
    }

    public void setAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
    }

    @JsonProperty(value="device_display_name")
    public String getDeviceDisplayName() {
        return this.deviceDisplayName;
    }

    public void setDeviceDisplayName(String deviceDisplayName) {
        this.deviceDisplayName = deviceDisplayName;
    }

    @JsonProperty(value="profile_tag")
    public String getProfileTag() {
        return this.profileTag;
    }

    public void setProfileTag(String profileTag) {
        this.profileTag = profileTag;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public PusherData getData() {
        return this.data;
    }

    public void setData(PusherData data) {
        this.data = data;
    }
}

