/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.sync;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Room summary.")
public class RoomSummary {
    @Schema(name="m.heroes", description="The users which can be used to generate a room name if the room does not have one. Required if the room's m.room.name or m.room.canonical_alias state events are unset or empty. This should be the first 5 members of the room, ordered by stream ordering, which are joined or invited. The list must never include the client's own user ID. When no joined or invited members are available, this should consist of the banned and left users. More than 5 members may be provided, however less than 5 should only be provided when there are less than 5 members to represent. When lazy-loading room members is enabled, the membership events for the heroes MUST be included in the state, unless they are redundant. When the list of users changes, the server notifies the client by sending a fresh list of heroes. If there are no changes since the last sync, this field may be omitted.")
    @JsonbProperty(value="m.heroes")
    private List<String> heroes;
    @Schema(name="m.joined_member_count", description="The number of users with membership of join, including the client's own user ID. If this field has not changed since the last sync, it may be omitted. Required otherwise.")
    @JsonbProperty(value="m.joined_member_count")
    private Long joinedMemberCount;
    @Schema(name="m.invited_member_count", description="The number of users with membership of invite. If this field has not changed since the last sync, it may be omitted. Required otherwise.")
    @JsonbProperty(value="m.invited_member_count")
    private Long invitedMemberCount;

    @JsonProperty(value="m.heroes")
    public List<String> getHeroes() {
        return this.heroes;
    }

    public void setHeroes(List<String> heroes) {
        this.heroes = heroes;
    }

    @JsonProperty(value="m.joined_member_count")
    public Long getJoinedMemberCount() {
        return this.joinedMemberCount;
    }

    public void setJoinedMemberCount(Long joinedMemberCount) {
        this.joinedMemberCount = joinedMemberCount;
    }

    @JsonProperty(value="m.invited_member_count")
    public Long getInvitedMemberCount() {
        return this.invitedMemberCount;
    }

    public void setInvitedMemberCount(Long invitedMemberCount) {
        this.invitedMemberCount = invitedMemberCount;
    }
}

