/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="Request for register for an account on this homeserver.")
public class RegisterRequest {
    @Schema(description="Additional authentication information for the user-interactive authentication API. Note that this information is not used to define how the registered user should be authenticated, but is instead used to authenticate the register call itself. It should be left empty, or omitted, unless an earlier call returned an response with status code 401.")
    private AuthenticationData auth;
    @Schema(description="If true, the server binds the email used for authentication to the Matrix ID with the ID Server.")
    @JsonbProperty(value="bind_email")
    private Boolean bindEmail;
    @Schema(description="If true, the server binds the phone number used for authentication to the Matrix ID with the identity server.")
    @JsonbProperty(value="bind_msisdn")
    private Boolean bindMsisdn;
    @Schema(description="The basis for the localpart of the desired Matrix ID. If omitted, the homeserver MUST generate a Matrix ID local part.")
    private String username;
    @Schema(description="The desired password for the account.")
    private char[] password;
    @Schema(description="ID of the client device. If this does not correspond to a known client device, a new device will be created. The server will auto-generate a device_id if this is not specified.")
    @JsonbProperty(value="device_id")
    private String deviceId;
    @Schema(description="A display name to assign to the newly-created device. Ignored if device_id corresponds to a known device.")
    @JsonbProperty(value="initial_device_display_name")
    private String initialDeviceDisplayName;
    @Schema(description="If true, an access_token and device_id should not be returned from this call, therefore preventing an automatic login.")
    @JsonbProperty(value="inhibit_login")
    private Boolean inhibitLogin;

    public AuthenticationData getAuth() {
        return this.auth;
    }

    public void setAuth(AuthenticationData auth) {
        this.auth = auth;
    }

    @JsonProperty(value="bind_email")
    public Boolean getBindEmail() {
        return this.bindEmail;
    }

    public void setBindEmail(Boolean bindEmail) {
        this.bindEmail = bindEmail;
    }

    @JsonProperty(value="bind_msisdn")
    public Boolean getBindMsisdn() {
        return this.bindMsisdn;
    }

    public void setBindMsisdn(Boolean bindMsisdn) {
        this.bindMsisdn = bindMsisdn;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @JsonProperty(value="initial_device_display_name")
    public String getInitialDeviceDisplayName() {
        return this.initialDeviceDisplayName;
    }

    public void setInitialDeviceDisplayName(String initialDeviceDisplayName) {
        this.initialDeviceDisplayName = initialDeviceDisplayName;
    }

    @JsonProperty(value="inhibit_login")
    public Boolean getInhibitLogin() {
        return this.inhibitLogin;
    }

    public void setInhibitLogin(Boolean inhibitLogin) {
        this.inhibitLogin = inhibitLogin;
    }
}

