/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot.command;

import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.Context;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.event.RoomEvent;

public class Help<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
implements Command<C, D, S, E> {
    @Override
    public String name() {
        return "help";
    }

    @Override
    public boolean invoke(Context<C, D, S, E> context, Id roomId, RoomEvent event, String arguments) {
        MatrixClient matrixClient = context.getMatrixClient();
        String prefix = context.getBot().getPrefix();
        String defaultCommand = ((BotConfig)context.getConfig()).getDefaultCommand();
        String help = context.getBot().getCommands().entrySet().stream().map(entry -> {
            StringBuilder commandHelp = new StringBuilder();
            if (defaultCommand != null && !defaultCommand.trim().isEmpty() && ((String)entry.getKey()).equals(defaultCommand)) {
                commandHelp.append("(default) ");
            }
            commandHelp.append(prefix).append(((Command)entry.getValue()).usage()).append(" - ").append(((Command)entry.getValue()).help()).append("\n");
            return commandHelp;
        }).reduce(StringBuilder::append).map(StringBuilder::toString).orElse("");
        matrixClient.event().sendNotice(roomId, help);
        return true;
    }

    @Override
    public String help() {
        return "list all commands.";
    }

    @Override
    public String usage() {
        return "help";
    }
}

