/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Api(value="ThirdPartyProtocol", description="Application services may declare which protocols they support via their registration configuration for the homeserver. These networks are generally for third party services such as IRC that the application service is managing. Application services may populate a Matrix room directory for their registered protocols, as defined in the Client-Server API Extensions.\nEach protocol may have several \"locations\"(also known as \"third party locations\" or \"3PLs\"). A location within a protocol is a place in the third party network, such as an IRC channel.Users of the third party network may also be represented by the application service.\nLocations and users can be searched by fields defined by the application service, such as by display name or other attribute. When clients request the homeserver to search in a particular \"network\" (protocol), the search fields will be passed along to the application service for filtering.")
@Path(value="/_matrix/app/v1/thirdparty")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ProtocolApi {
    @ApiOperation(value="This API is called by the homeserver when it wants to present clients with specific information about the various third party networks that an application service supports.", response=Protocol.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The protocol was found and metadata returned."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="No protocol was found with the given path.The protocol is unknown.")})
    @Secured
    @GET
    @Path(value="/protocol/{protocol}")
    public void protocol(@ApiParam(value="the name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Retrieve a list of Matrix portal rooms that lead to the matched third party location.", response=ProtocolLocation.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="At least one portal room was found."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="No mappings were found with the given parameters.")})
    @Secured
    @GET
    @Path(value="/location/{protocol}")
    public void locationProtocol(@ApiParam(value="The protocol ID.", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="Retrieve a Matrix User ID linked to a user on the third party service, given a set of user parameters.", response=ProtocolUser.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="The Matrix User IDs found with the given parameters."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="No users were found with the given parameters.")})
    @Secured
    @GET
    @Path(value="/user/{protocol}")
    public void userProtocol(@ApiParam(value="The name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="Retrieve an array of third party network locations from a Matrix room alias.", response=ProtocolLocation.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="At least one portal room was found."), @ApiResponse(code=404, message="No portal rooms were found.")})
    @Secured
    @GET
    @Path(value="/location")
    public void location(@ApiParam(value="The Matrix room alias to look up.", required=true) @QueryParam(value="alias") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Retrieve an array of third party users from a Matrix User ID.", response=ProtocolUser.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="An array of third party users."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="No mappings were found with the given parameters.")})
    @Secured
    @GET
    @Path(value="/user")
    public void user(@ApiParam(value="The Matrix User Id to look up", required=true) @QueryParam(value="userid") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

