/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.application.model.TransactionRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="ApplicationService", description="All application services MUST implement these APIs.")
@Path(value="/_matrix/app/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ApplicationApi {
    @ApiOperation(value="This API is called by the homeserver when it wants to push an event (or batch of events) to the application service.", notes="Note that the application service should distinguish state events from message events via the presence of a state_key, rather than via the event type.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The transaction was processed successfully.")})
    @PUT
    @Path(value="/transactions/{txnId}")
    public void transaction(@ApiParam(name="txnId", value="The transaction ID for this set of events. Homeservers generate these IDs and they are used to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var1, @ApiParam(value="JSON body request.") TransactionRequest var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4);

    @ApiOperation(value="This endpoint is invoked by the homeserver on an application service to query the existence of a given room alias.", notes="The homeserver will only query room aliases inside the application service's aliases namespace. The homeserver will send this request when it receives a request to join a room alias within the application service's namespace.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The application service indicates that this room alias exists. The application service MUST have created a room and associated it with the queried room alias using the client-server API. Additional information about the room such as its name and topic can be set before responding."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="The application service indicates that this room alias does not exist. Optional error information can be included in the body of this response.")})
    @GET
    @Path(value="/rooms/{roomAlias}")
    public void rooms(@ApiParam(name="roomAlias", value="The room alias being queried.", required=true) @PathParam(value="roomAlias") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="This endpoint is invoked by the homeserver on an application service to query the existence of a given user ID.", notes="The homeserver will only query user IDs inside the application service's users namespace. The homeserver will send this request when it receives an event for an unknown user ID in the application service's namespace.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The application service indicates that this user exists. The application service MUST create the user using the client-server API."), @ApiResponse(code=401, message="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response."), @ApiResponse(code=403, message="The credentials supplied by the homeserver were rejected."), @ApiResponse(code=404, message="The application service indicates that this user does not exist. Optional error information can be included in the body of this response.")})
    @GET
    @Path(value="/users/{userId}")
    public void users(@ApiParam(name="userId", value="The user ID being queried.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

