/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/app/v1/thirdparty")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ProtocolApi {
    @Operation(summary="This API is called by the homeserver when it wants to present clients with specific information about the various third party networks that an application service supports.", responses={@ApiResponse(responseCode="200", description="The protocol was found and metadata returned.", content={@Content(schema=@Schema(implementation=Protocol.class))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No protocol was found with the given path.The protocol is unknown.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Secured
    @GET
    @Path(value="/protocol/{protocol}")
    public void protocol(@Parameter(description="the name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve a list of Matrix portal rooms that lead to the matched third party location.", responses={@ApiResponse(responseCode="200", description="At least one portal room was found.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolLocation.class)))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No mappings were found with the given parameters.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Secured
    @GET
    @Path(value="/location/{protocol}")
    public void locationProtocol(@Parameter(description="The protocol ID.", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve a Matrix User ID linked to a user on the third party service, given a set of user parameters.", responses={@ApiResponse(responseCode="200", description="The Matrix User IDs found with the given parameters.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolUser.class)))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No users were found with the given parameters.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Secured
    @GET
    @Path(value="/user/{protocol}")
    public void userProtocol(@Parameter(description="The name of the protocol", required=true) @PathParam(value="protocol") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve an array of third party network locations from a Matrix room alias.", responses={@ApiResponse(responseCode="200", description="At least one portal room was found.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolLocation.class)))}), @ApiResponse(responseCode="404", description="No portal rooms were found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Secured
    @GET
    @Path(value="/location")
    public void location(@Parameter(description="The Matrix room alias to look up.", required=true) @QueryParam(value="alias") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Retrieve an array of third party users from a Matrix User ID.", responses={@ApiResponse(responseCode="200", description="An array of third party users.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProtocolUser.class)))}), @ApiResponse(responseCode="401", description="The homeserver has not supplied credentials to the application service. Optional error information can be included in the body of this response.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="The credentials supplied by the homeserver were rejected.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="No mappings were found with the given parameters.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @Secured
    @GET
    @Path(value="/user")
    public void user(@Parameter(description="The Matrix User Id to look up", required=true) @QueryParam(value="userid") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);
}

