/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.xml;

import com.luna.common.file.FileTools;
import com.luna.common.io.IoUtil;
import com.luna.common.text.CharsetUtil;
import com.luna.common.text.StringTools;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class JAXBUtil {
    public static String beanToXml(Object bean) {
        return JAXBUtil.beanToXml(bean, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String beanToXml(Object bean, Charset charset, boolean format) {
        StringWriter writer;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            writer = new StringWriter();
            marshaller.marshal(bean, (Writer)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("convertToXml \u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        return writer.toString();
    }

    public static <T> T xmlToBean(String xml, Class<T> c) {
        return JAXBUtil.xmlToBean(StringTools.getReader(xml), c);
    }

    public static <T> T xmlToBean(File file, Charset charset, Class<T> c) {
        return JAXBUtil.xmlToBean(FileTools.getReader(file, charset), c);
    }

    public static <T> T xmlToBean(Reader reader, Class<T> c) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(reader);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("convertToJava2 \u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        finally {
            IoUtil.close(reader);
        }
    }
}

