/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.thread;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScheduledAsyncExecutor {
    private static final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(5, runnable -> new Thread(runnable, "ScheduledAsyncExecute-" + Thread.currentThread().getName()));

    public static Future async(Runnable method) {
        return scheduledThreadPoolExecutor.submit(method);
    }

    public static <P> Future async(Consumer<P> method, P param) {
        return scheduledThreadPoolExecutor.submit(() -> method.accept(param));
    }

    public static <P1, P2> Future submit(BiConsumer<P1, P2> method, P1 param1, P2 param2) {
        return scheduledThreadPoolExecutor.submit(() -> method.accept(param1, param2));
    }

    public static <R> Future<R> submit(Supplier<R> method) {
        return scheduledThreadPoolExecutor.submit(method::get);
    }

    public static <T> Future<T> submit(Runnable task, T result) {
        return scheduledThreadPoolExecutor.submit(task, result);
    }

    public static <P, R> Future<R> submit(Function<P, R> method, P param) {
        return scheduledThreadPoolExecutor.submit(() -> method.apply(param));
    }

    public static <P1, P2, R> Future<R> async(BiFunction<P1, P2, R> method, P1 param1, P2 param2) {
        return scheduledThreadPoolExecutor.submit(() -> method.apply(param1, param2));
    }

    public static <P> void scheduleWithFixedDelay(Consumer<P> method, P param1, long initialDelay, long delay, TimeUnit unit) {
        scheduledThreadPoolExecutor.scheduleWithFixedDelay(() -> method.accept(param1), initialDelay, delay, unit);
    }

    public static <P> void scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit unit) {
        scheduledThreadPoolExecutor.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
    }

    public static void main(String[] args) {
        ScheduledAsyncExecutor.scheduleWithFixedDelay(() -> System.out.println("hello"), 1L, 1L, TimeUnit.SECONDS);
        Future<String> hello = ScheduledAsyncExecutor.submit(() -> "helloFuture");
        String o = hello.get();
        System.out.println((Object)o);
    }
}

