/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.sensitive;

import org.apache.commons.lang3.StringUtils;

public class Convert {
    private static final String DEFAULT_MASK = "*";

    public static String maskValue(String value, int prefixNoMaskLen, int suffixNoMaskLen, String maskStr) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            if (i < prefixNoMaskLen) {
                sb.append(value.charAt(i));
                continue;
            }
            if (i > n - suffixNoMaskLen - 1) {
                sb.append(value.charAt(i));
                continue;
            }
            sb.append(maskStr);
        }
        return sb.toString();
    }

    public static String chineseName(String fullName) {
        if (fullName.length() > 2) {
            return Convert.maskValue(fullName, 1, 1, DEFAULT_MASK);
        }
        return Convert.maskValue(fullName, 1, 0, DEFAULT_MASK);
    }

    public static String chineseNameFirst(String fullName) {
        return Convert.maskValue(fullName, 1, 0, DEFAULT_MASK);
    }

    public static String idCard(String id) {
        return Convert.maskValue(id, 6, 4, DEFAULT_MASK);
    }

    public static String fixedPhone(String num) {
        return Convert.maskValue(num, 0, 4, DEFAULT_MASK);
    }

    public static String mobile(String num) {
        return Convert.maskValue(num, 3, 4, DEFAULT_MASK);
    }

    public static String address(String address) {
        return Convert.maskValue(address, 6, 0, DEFAULT_MASK);
    }

    public static String email(String email) {
        int index = email.indexOf(64);
        if (index <= 1) {
            return email;
        }
        return Convert.maskValue(email, 1, email.length() - index, DEFAULT_MASK);
    }

    public static String bankCard(String cardNum) {
        return Convert.maskValue(cardNum, 6, 4, DEFAULT_MASK);
    }

    public static String carNumber(String carNumber) {
        return Convert.maskValue(carNumber, 2, 1, DEFAULT_MASK);
    }

    public static String all(String password) {
        return Convert.maskValue(password, 0, 0, DEFAULT_MASK);
    }

    public static String key(String key) {
        return Convert.maskValue(key, 0, 3, DEFAULT_MASK);
    }
}

