/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net.async;

import com.luna.common.net.async.CustomResponseBody;
import java.util.Iterator;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;

public final class CustomAsyncHttpResponse
extends BasicClassicHttpResponse {
    private static final long serialVersionUID = 1L;
    private CustomResponseBody body;

    public CustomAsyncHttpResponse(int code) {
        super(code);
    }

    public CustomAsyncHttpResponse(int code, String reasonPhrase) {
        super(code, reasonPhrase);
    }

    public static CustomAsyncHttpResponse copy(HttpResponse original) {
        CustomAsyncHttpResponse copy = new CustomAsyncHttpResponse(original.getCode());
        copy.setVersion(original.getVersion());
        Iterator it = original.headerIterator();
        while (it.hasNext()) {
            copy.addHeader((Header)it.next());
        }
        return copy;
    }

    public static CustomAsyncHttpResponse create(int code) {
        return new CustomAsyncHttpResponse(code);
    }

    public static CustomAsyncHttpResponse create(int code, String content, ContentType contentType) {
        CustomAsyncHttpResponse response = new CustomAsyncHttpResponse(code);
        if (content != null) {
            response.setBody(content, contentType);
        }
        return response;
    }

    public static CustomAsyncHttpResponse create(int code, String content) {
        return CustomAsyncHttpResponse.create(code, content, ContentType.TEXT_PLAIN);
    }

    public static CustomAsyncHttpResponse create(int code, byte[] content, ContentType contentType) {
        CustomAsyncHttpResponse response = new CustomAsyncHttpResponse(code);
        if (content != null) {
            response.setBody(content, contentType);
        }
        return response;
    }

    public static CustomAsyncHttpResponse create(int code, byte[] content) {
        return CustomAsyncHttpResponse.create(code, content, ContentType.TEXT_PLAIN);
    }

    public void setBody(byte[] bodyBytes, ContentType contentType) {
        this.body = CustomResponseBody.create(bodyBytes, contentType);
    }

    public void setBody(String bodyText, ContentType contentType) {
        this.body = CustomResponseBody.create(bodyText, contentType);
    }

    public CustomResponseBody getBody() {
        return this.body;
    }

    public void setBody(CustomResponseBody body) {
        this.body = body;
    }

    public ContentType getContentType() {
        return this.body != null ? this.body.getContentType() : null;
    }

    public String getBodyText() {
        return this.body != null ? this.body.getBodyText() : null;
    }

    public byte[] getBodyBytes() {
        return this.body != null ? this.body.getBodyBytes() : null;
    }
}

