/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.net;

import com.google.common.collect.ImmutableList;
import com.luna.common.file.FileTools;
import com.luna.common.net.method.HttpDelete;
import com.luna.common.text.CharsetUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.util.TimeValue;

public class HttpUtils {
    public static final HttpClientContext CLIENT_CONTEXT = HttpClientContext.create();
    public static final BasicCookieStore COOKIE_STORE = new BasicCookieStore();
    private static final HttpClientBuilder HTTP_CLIENT_BUILDER = HttpClients.custom();
    public static int MAX_REDIRECTS = 10;
    public static int MAX_CONN = 200;
    public static int CONNECT_TIMEOUT = 10;
    public static int RESPONSE_TIMEOUT = 30;
    public static int MAX_ROUTE = 200;
    public static int SOCKET_TIME_OUT = 100;
    private static CloseableHttpClient httpClient;

    public static void init() {
        PlainConnectionSocketFactory socketFactory = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build();
            socketFactory = new SSLConnectionSocketFactory(sslContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)(socketFactory != null ? socketFactory : PlainConnectionSocketFactory.getSocketFactory())).build();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("strict").setMaxRedirects(MAX_REDIRECTS).setResponseTimeout((long)RESPONSE_TIMEOUT, TimeUnit.SECONDS).setConnectionRequestTimeout((long)CONNECT_TIMEOUT, TimeUnit.SECONDS).setTargetPreferredAuthSchemes(Arrays.asList("Basic", "Digest")).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).build();
        SystemDefaultDnsResolver dnsResolver = new SystemDefaultDnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                if (host.equalsIgnoreCase("localhost")) {
                    return new InetAddress[]{InetAddress.getByAddress(new byte[]{127, 0, 0, 1})};
                }
                return super.resolve(host);
            }
        };
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.ofMinutes((long)5L), (SchemePortResolver)DefaultSchemePortResolver.INSTANCE, (DnsResolver)dnsResolver, (HttpConnectionFactory)ManagedHttpClientConnectionFactory.INSTANCE);
        cm.setMaxTotal(MAX_CONN);
        cm.setDefaultMaxPerRoute(MAX_ROUTE);
        cm.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(TimeValue.ofSeconds((long)CONNECT_TIMEOUT)).setTimeToLive(TimeValue.ofHours((long)1L)).build());
        cm.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(SOCKET_TIME_OUT, TimeUnit.SECONDS).build());
        HTTP_CLIENT_BUILDER.setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(defaultRequestConfig);
        httpClient = HTTP_CLIENT_BUILDER.build();
    }

    public static void refresh() {
        HTTP_CLIENT_BUILDER.setDefaultCookieStore((CookieStore)COOKIE_STORE);
        httpClient = HTTP_CLIENT_BUILDER.build();
    }

    public static void basicAuth(String userName, String password, String host) {
        HttpUtils.authContext(userName, password, host, "Basic");
    }

    public static void digestAuth(String userName, String password, String host) {
        HttpUtils.authContext(userName, password, host, "Digest");
    }

    public static void authContext(String userName, String password, String host, String authType) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password.toCharArray());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(null, -1);
        AuthCache authCache = CLIENT_CONTEXT.getAuthCache();
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            HttpHost targetHost = new HttpHost(host);
            if (authCache == null) {
                authCache = new BasicAuthCache();
            }
            if ("Basic".equals(authType)) {
                BasicScheme basicScheme = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicScheme);
                basicScheme.initPreemptive((Credentials)credentials);
            } else if ("Digest".equals(authType)) {
                DigestScheme digestScheme = new DigestScheme();
                authCache.put(targetHost, (AuthScheme)digestScheme);
            }
        }
        credsProvider.setCredentials(authScope, (Credentials)credentials);
        CLIENT_CONTEXT.setCredentialsProvider((CredentialsProvider)credsProvider);
        CLIENT_CONTEXT.setAuthCache(authCache);
    }

    public static void setProxy(Integer port) {
        HttpUtils.setProxy("127.0.0.1", port);
    }

    public static void setProxy(String host, Integer port) {
        HttpHost proxy = new HttpHost(host, port.intValue());
        DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(proxy);
        HTTP_CLIENT_BUILDER.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner);
        HttpUtils.refresh();
    }

    public static void setProxy(String host, Integer port, String username, String password) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            HttpUtils.authContext(username, password, host, "Basic");
        }
        HttpUtils.setProxy(host, port);
    }

    public static void builderHeader(Map<String, String> headers, BasicClassicHttpRequest requestBase) {
        if (MapUtils.isEmpty(headers)) {
            return;
        }
        headers.forEach((arg_0, arg_1) -> ((BasicClassicHttpRequest)requestBase).addHeader(arg_0, arg_1));
    }

    public static void builderHeader(Map<String, String> headers, AsyncRequestBuilder requestBase) {
        if (MapUtils.isEmpty(headers)) {
            return;
        }
        headers.forEach((arg_0, arg_1) -> ((AsyncRequestBuilder)requestBase).addHeader(arg_0, arg_1));
    }

    public static List<Cookie> getCookie() {
        return COOKIE_STORE.getCookies();
    }

    public static void addCookie(Cookie cookie) {
        COOKIE_STORE.addCookie(cookie);
    }

    public static void addCookie(List<Cookie> cookies) {
        cookies.forEach(arg_0 -> ((BasicCookieStore)COOKIE_STORE).addCookie(arg_0));
    }

    public static void addCookie(Cookie ... cookies) {
        Arrays.stream(cookies).forEach(arg_0 -> ((BasicCookieStore)COOKIE_STORE).addCookie(arg_0));
    }

    private static <T> T doRequest(HttpClientResponseHandler<T> responseHandler, HttpUriRequestBase request) {
        try {
            if (responseHandler == null) {
                return (T)httpClient.execute((ClassicHttpRequest)request, (HttpContext)CLIENT_CONTEXT);
            }
            return (T)httpClient.execute((ClassicHttpRequest)request, (HttpContext)CLIENT_CONTEXT, responseHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpResponse doHead(String url) {
        HttpHead request = new HttpHead(url);
        CloseableHttpResponse response = (CloseableHttpResponse)HttpUtils.doRequest(null, (HttpUriRequestBase)request);
        return response;
    }

    public static HttpResponse doGet(String url, Map<String, String> headers) {
        HttpGet request = new HttpGet(HttpUtils.buildUrl(url, "", new HashMap(0)));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return (HttpResponse)HttpUtils.doRequest(null, (HttpUriRequestBase)request);
    }

    public static <T> T doGet(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpClientResponseHandler<T> responseHandler) {
        HttpGet request = new HttpGet(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        return HttpUtils.doRequest(responseHandler, (HttpUriRequestBase)request);
    }

    public static String doGetHandler(String host, String path, Map<String, String> headers, Map<String, String> queries) {
        return (String)HttpUtils.doGet(host, path, headers, queries, new BasicHttpClientResponseHandler());
    }

    public static ClassicHttpResponse doGet(String host, String path, Map<String, String> headers, Map<String, String> queries) {
        return (ClassicHttpResponse)HttpUtils.doGet(host, path, headers, queries, null);
    }

    public static <T> T doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries, String body, HttpClientResponseHandler<T> responseHandler) {
        HttpDelete delete = new HttpDelete(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)delete);
        if (StringUtils.isNotBlank((CharSequence)body)) {
            delete.setEntity((HttpEntity)new StringEntity(body, Charset.defaultCharset()));
        }
        return HttpUtils.doRequest(responseHandler, delete);
    }

    public static String doDeleteHandler(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (String)HttpUtils.doDelete(host, path, headers, queries, body, new BasicHttpClientResponseHandler());
    }

    public static ClassicHttpResponse doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (ClassicHttpResponse)HttpUtils.doDelete(host, path, headers, queries, body, null);
    }

    public static <T> T doPut(String host, String path, Map<String, String> headers, Map<String, String> queries, String body, HttpClientResponseHandler<T> responseHandler) {
        HttpPut httpPut = new HttpPut(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)httpPut);
        if (StringUtils.isNotBlank((CharSequence)body)) {
            httpPut.setEntity((HttpEntity)new StringEntity(body, Charset.defaultCharset()));
        }
        return HttpUtils.doRequest(responseHandler, (HttpUriRequestBase)httpPut);
    }

    public static ClassicHttpResponse doPut(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (ClassicHttpResponse)HttpUtils.doPut(host, path, headers, queries, body, null);
    }

    public static String doPutHandler(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (String)HttpUtils.doPut(host, path, headers, queries, body, new BasicHttpClientResponseHandler());
    }

    public static <T> T doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies, HttpClientResponseHandler<T> responseHandler) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.LEGACY);
        builder.setCharset(CharsetUtil.defaultCharset());
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        if (MapUtils.isNotEmpty(bodies)) {
            bodies.forEach((k, v) -> {
                File file = new File((String)v);
                builder.addBinaryBody(k, file);
            });
        }
        HttpEntity reqEntity = builder.build();
        return HttpUtils.doPost(host, path, headers, queries, reqEntity, responseHandler);
    }

    private static void close(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> void doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies, HttpClientResponseHandler<T> responseHandler, FutureCallback<Object> futureCallback) {
        if (MapUtils.isNotEmpty(bodies)) {
            bodies.forEach((k, v) -> {
                boolean notExists = FileTools.notExists(v);
                if (notExists) {
                    return;
                }
                File file = new File((String)v);
                HttpUtils.breakingPointUpload(host, path, headers, queries, k, file, futureCallback);
            });
        }
        try {
            responseHandler.handleResponse((ClassicHttpResponse)new BasicClassicHttpResponse(200));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void breakingPointDownload(String host, String path, Map<String, String> headers, Map<String, String> queries, FutureCallback<Object> futureCallback) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void breakingPointUpload(String host, String path, Map<String, String> headers, Map<String, String> queries, String key, File file, FutureCallback<Object> futureCallback) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.LEGACY);
        builder.setCharset(CharsetUtil.defaultCharset());
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        RandomAccessFile rw = null;
        FileOutputStream fos = null;
        try {
            long length = file.length();
            int size = 0xA00000;
            int round = (int)Math.ceil((double)length / (double)size);
            rw = new RandomAccessFile(file, "rw");
            long start = 0L;
            for (int i = 0; i < round; ++i) {
                Date startDate = new Date();
                long end = start + (long)size;
                if (end > length) {
                    size = (int)(length - start);
                    end = start + (long)size;
                }
                headers.put("Range", "bytes=" + start + "-" + end);
                rw.seek(start);
                byte[] bytes = new byte[size];
                int read = rw.read(bytes);
                File tmpFile = new File(System.getProperty("java.io.tmpdir"));
                fos = new FileOutputStream(tmpFile);
                fos.write(bytes, 0, read);
                fos.flush();
                fos.close();
                FileBody bin = new FileBody(tmpFile);
                builder.addPart(key, (ContentBody)bin);
                HttpEntity reqEntity = builder.build();
                HttpEntity httpEntity = (HttpEntity)HttpUtils.doPost(host, path, headers, queries, reqEntity, HttpEntityContainer::getEntity);
                EntityUtils.consume((HttpEntity)httpEntity);
                headers.remove("Range");
                tmpFile.delete();
                start += (long)size;
                Date endDate = new Date();
                long time = endDate.getTime() - startDate.getTime();
                System.out.println("\u7528\u65f6====" + time);
            }
            futureCallback.completed((Object)new BasicClassicHttpResponse(200));
        }
        catch (IOException e) {
            try {
                futureCallback.cancelled();
                futureCallback.failed((Exception)e);
            }
            catch (Throwable throwable) {
                HttpUtils.close(fos, rw);
                throw throwable;
            }
            HttpUtils.close(fos, rw);
        }
        HttpUtils.close(fos, rw);
    }

    public static ClassicHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies) {
        return (ClassicHttpResponse)HttpUtils.doPost(host, path, headers, queries, bodies, null);
    }

    public static <T> T doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, String body, HttpClientResponseHandler<T> responseHandler) {
        return HttpUtils.doPost(host, path, headers, queries, (HttpEntity)new StringEntity(body, Charset.defaultCharset()), responseHandler);
    }

    public static <T> T doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, HttpEntity httpEntity, HttpClientResponseHandler<T> responseHandler) {
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, queries));
        HttpUtils.builderHeader(headers, (BasicClassicHttpRequest)request);
        if (httpEntity != null) {
            request.setEntity(httpEntity);
        }
        return HttpUtils.doRequest(responseHandler, (HttpUriRequestBase)request);
    }

    public static ClassicHttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (ClassicHttpResponse)HttpUtils.doPost(host, path, headers, queries, body, null);
    }

    public static String doPostHander(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) {
        return (String)HttpUtils.doPost(host, path, headers, queries, body, new BasicHttpClientResponseHandler());
    }

    public static <T> T doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body, HttpClientResponseHandler<T> responseHandler) {
        return HttpUtils.doPost(host, path, headers, queries, (HttpEntity)new ByteArrayEntity(body, ContentType.APPLICATION_OCTET_STREAM), responseHandler);
    }

    public static HttpResponse doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body) {
        return (HttpResponse)HttpUtils.doPost(host, path, headers, queries, body, null);
    }

    public static boolean isUrl(String url) {
        url = url.toLowerCase();
        String regex = "^((https|http|ftp|rtsp|mms)?://)?(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?(([0-9]{1,3}\\.){3}[0-9]{1,3}|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6})(:[0-9]{1,5})?((/?)|(/[0-9a-z_!~*'().;?:@&=+$,%#-]+)+/?)$";
        return url.matches(regex);
    }

    public static String buildUrlHead(String host, String path) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            if (!path.startsWith("/")) {
                path = path + "/";
            }
            sbUrl.append(path);
        }
        return sbUrl.toString();
    }

    public static String buildUrlObject(String host, String path, Map<String, Object> queries) {
        return HttpUtils.buildUrl(host, path, queries);
    }

    public static String buildUrlString(String host, String path, Map<String, String> queries) {
        return HttpUtils.buildUrl(host, path, queries);
    }

    public static String buildUrl(String host, String path, Map<?, ?> queries) {
        StringBuilder sbUrl = new StringBuilder(HttpUtils.buildUrlHead(host, path));
        if (MapUtils.isEmpty(queries)) {
            return sbUrl.toString();
        }
        String sbQuery = HttpUtils.urlEncode(queries);
        if (StringUtils.isNotBlank((CharSequence)sbQuery)) {
            sbUrl.append("?").append(sbQuery);
        }
        return sbUrl.toString();
    }

    public static String getUserInfo(String url, String username, String password) {
        try {
            if (username == null && password == null) {
                return url;
            }
            URIBuilder uriBuilder = new URIBuilder(url).setUserInfo(username + ':' + password);
            return uriBuilder.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String checkResponseAndGetResultV2(ClassicHttpResponse httpResponse, boolean isEnsure) {
        if (httpResponse == null) {
            throw new RuntimeException();
        }
        if (isEnsure && 200 != httpResponse.getCode()) {
            throw new RuntimeException();
        }
        HttpEntity entity = httpResponse.getEntity();
        try {
            return EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] checkResponseStreamAndGetResult(ClassicHttpResponse httpResponse) {
        if (Objects.isNull(httpResponse)) {
            throw new NullPointerException();
        }
        if (200 != httpResponse.getCode()) {
            throw new RuntimeException();
        }
        HttpEntity entity = httpResponse.getEntity();
        try {
            return EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlEncode(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        map.forEach((k, v) -> {
            try {
                if (ObjectUtils.isNotEmpty((Object)k) && ObjectUtils.isNotEmpty((Object)v)) {
                    sb.append(String.format("%s=%s", URLEncoder.encode(k.toString(), CharsetUtil.defaultCharsetName()), URLEncoder.encode(v.toString(), CharsetUtil.defaultCharsetName())));
                }
                sb.append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        });
        return sb.toString();
    }

    public static String urlEncodeWithUtf8(String s) {
        return HttpUtils.urlEncode(s, "UTF-8");
    }

    public static String urlEncode(String s, String chareset) {
        try {
            return URLEncoder.encode(s, chareset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] checkResponseStreamAndGetResult(ClassicHttpResponse httpResponse, List<Integer> statusList) {
        HttpUtils.checkCode(httpResponse, statusList);
        HttpEntity entity = httpResponse.getEntity();
        try {
            return EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String checkResponseAndGetResult(ClassicHttpResponse httpResponse, List<Integer> statusList) {
        HttpUtils.checkCode(httpResponse, statusList);
        HttpEntity entity = httpResponse.getEntity();
        try {
            return EntityUtils.toString((HttpEntity)entity, (Charset)Charset.defaultCharset());
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkCode(ClassicHttpResponse httpResponse, List<Integer> statusList) {
        if (httpResponse == null) {
            throw new RuntimeException();
        }
        if (!statusList.contains(httpResponse.getCode())) {
            throw new RuntimeException();
        }
    }

    public static String checkResponseAndGetResult(ClassicHttpResponse httpResponse) {
        return HttpUtils.checkResponseAndGetResult(httpResponse, (List<Integer>)ImmutableList.of((Object)200));
    }

    public static String checkResponseAndGetResult(HttpResponse httpResponse) {
        return HttpUtils.checkResponseAndGetResult((ClassicHttpResponse)httpResponse, (List<Integer>)ImmutableList.of((Object)200));
    }

    public static String checkResponseAndGetResult(HttpResponse httpResponse, Boolean isEnsure) {
        return HttpUtils.checkResponseAndGetResultV2((ClassicHttpResponse)httpResponse, isEnsure);
    }

    public void addRequestInterceptorFirst(HttpRequestInterceptor httpRequestInterceptor) {
        HTTP_CLIENT_BUILDER.addRequestInterceptorFirst(httpRequestInterceptor);
        HttpUtils.refresh();
    }

    public void addExecInterceptorAfter(String existing, String name, ExecChainHandler interceptor) {
        HTTP_CLIENT_BUILDER.addExecInterceptorAfter(existing, name, interceptor);
        HttpUtils.refresh();
    }

    static {
        HttpUtils.init();
    }
}

