/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class MathUtils {
    private static final BigDecimal HUNDRED_B = new BigDecimal("100");

    public static long pow(long a, long b) {
        return new BigDecimal(a).pow((int)b).longValue();
    }

    public static BigDecimal substract(BigDecimal b1, BigDecimal b2) {
        if (null == b1 || null == b2) {
            return null;
        }
        int scale = 2;
        return MathUtils.substract(b1, b2, scale);
    }

    public static BigDecimal substract(BigDecimal b1, BigDecimal b2, int scale) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.subtract(b2).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.divide(b2, 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, int scale) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.divide(b2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal b1, BigDecimal b2, int scale, RoundingMode roundingMode) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.divide(b2, scale, roundingMode);
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal b2, int scale, RoundingMode roundingMode) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.add(b2, new MathContext(scale, roundingMode));
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal b2, int scale) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.add(b2, new MathContext(scale, RoundingMode.HALF_UP));
    }

    public static BigDecimal add(BigDecimal b1, BigDecimal b2) {
        if (null == b1 || null == b2) {
            return null;
        }
        return b1.add(b2);
    }

    public static BigDecimal roundingMode(BigDecimal bigDecimal, int scale, RoundingMode roundingMode) {
        return bigDecimal.setScale(scale, roundingMode);
    }

    public static BigDecimal disZeros(BigDecimal b1) {
        return b1.stripTrailingZeros();
    }

    public static String toPlainString(BigDecimal b1) {
        return b1.toPlainString();
    }

    public static BigDecimal percentMultiply(BigDecimal b1, BigDecimal b2) {
        if (null == b1 || null == b2) {
            return null;
        }
        int scale = 4;
        return b1.multiply(b2).divide(HUNDRED_B, scale, RoundingMode.HALF_UP);
    }
}

