/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.file;

import com.google.common.collect.ImmutableMap;
import com.luna.common.text.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class FileSystemUtil {
    public static FileSystem create(String path) {
        try {
            return FileSystems.newFileSystem(Paths.get(path, new String[0]).toUri(), ImmutableMap.of((Object)"create", (Object)"true"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileSystem createZip(String path) {
        return FileSystemUtil.createZip(path, null);
    }

    public static FileSystem createZip(String path, Charset charset) {
        if (null == charset) {
            charset = CharsetUtil.CHARSET_UTF_8;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        env.put("encoding", charset.name());
        try {
            return FileSystems.newFileSystem(URI.create("jar:" + Paths.get(path, new String[0]).toUri()), env);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path getRoot(FileSystem fileSystem) {
        return fileSystem.getPath("/", new String[0]);
    }
}

