/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.engine.task;

import com.luna.common.engine.model.EngineContext;
import com.luna.common.engine.model.EngineRunData;
import com.luna.common.engine.spi.BatchNodeNodeSpi;
import com.luna.common.engine.spi.NodeSpi;
import com.luna.common.engine.task.EngineNode;
import com.luna.common.engine.task.TradeEngineCallable;
import com.luna.common.exception.BaseException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeParallelTask
extends TradeEngineCallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeParallelTask.class);
    public static volatile boolean PRINT_NODE_EXECUTE_TIME_LOG = false;
    public static volatile boolean PRINT_PERF_ANALYZE_LOG = false;
    private EngineNode engineNode;
    private EngineRunData engineRunData;
    private EngineContext engineContext;

    public NodeParallelTask(EngineNode engineNode, EngineRunData engineRunData, EngineContext engineContext) {
        this.engineNode = engineNode;
        this.engineRunData = engineRunData;
        this.engineContext = engineContext;
    }

    Object _call() throws BaseException {
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws BaseException {
        long start = System.currentTimeMillis();
        try {
            Object o = this.engineNode.invokeNode(this.engineRunData, this.engineContext);
            List<NodeSpi> spiList = this.engineNode.getSpiList();
            if (CollectionUtils.isNotEmpty(spiList)) {
                for (NodeSpi nodeSpi : spiList) {
                    BatchNodeNodeSpi batchNodeNodeSpi = (BatchNodeNodeSpi)nodeSpi;
                    if (!batchNodeNodeSpi.isAccept(this.engineRunData)) continue;
                    batchNodeNodeSpi.invoke(this.engineRunData);
                }
            }
            this.engineNode.afterInvoke(this.engineRunData, this.engineContext);
            Iterator<NodeSpi> iterator = o;
            return iterator;
        }
        finally {
            long end = System.currentTimeMillis();
            if (PRINT_NODE_EXECUTE_TIME_LOG && end - start > 100L) {
                LOGGER.warn("fatal error, please notice. execute node:{} exceed times " + (end - start) + " millisecond ", (Object)this.engineNode.getClass().getName());
            }
            if (PRINT_PERF_ANALYZE_LOG) {
                LOGGER.warn("==========execute node:{} total use " + (end - start) + " millisecond ===========", (Object)this.engineNode.getClass().getName());
            }
        }
    }
}

