/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.engine.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.luna.common.engine.model.EngineContext;
import com.luna.common.engine.model.EngineRunData;
import com.luna.common.engine.model.NodeChain;
import com.luna.common.engine.model.NodeConf;
import com.luna.common.engine.model.NodeName;
import com.luna.common.engine.task.EngineNode;
import com.luna.common.engine.task.NodeParallelTask;
import com.luna.common.exception.BaseException;
import com.luna.common.spring.SpringBeanService;
import com.luna.common.thread.CommonThreadPoolUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEngineExecute<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEngineExecute.class);
    private static CommonThreadPoolUtil COMMON_THREAD_POOL_UTIL = new CommonThreadPoolUtil();

    public T execute(NodeChain nodeChainChain, EngineRunData engineRunData, EngineContext engineContext) {
        Map<String, List<NodeName>> nodeGroup = this.groupByGroupName(nodeChainChain);
        Map<NodeName, NodeConf> nodeMap = nodeChainChain.getNodeMap();
        for (String groupName : nodeGroup.keySet()) {
            BaseException exp = null;
            boolean needThrowExp = false;
            List<NodeName> nodeNameList = nodeGroup.get(groupName);
            if (nodeNameList.size() == 1) {
                NodeName nodeName = nodeNameList.get(0);
                EngineNode detailNode = (EngineNode)SpringBeanService.getSingleBeanByType(Class.forName(nodeName.getNodeName()));
                NodeParallelTask nodeParallelTask = new NodeParallelTask(detailNode, engineRunData, engineContext);
                try {
                    Object result = nodeParallelTask.execute();
                    engineContext.getAdaptorMap().put(detailNode.resultKey(), result);
                }
                catch (BaseException e) {
                    needThrowExp = this.isStrongRely(nodeMap, nodeName);
                    if (!this.isStrongRely(nodeMap, nodeName)) {
                        log.warn("detailnode occur exception !!!", (Throwable)e);
                    }
                    exp = e;
                }
                catch (Exception e) {
                    needThrowExp = this.isStrongRely(nodeMap, nodeName);
                    if (!this.isStrongRely(nodeMap, nodeName)) {
                        log.error("detailEngine execute throw unknown Exception 2", (Throwable)e);
                    }
                    exp = BaseException.SYSTEM_ERROR;
                }
            } else {
                EngineNode detailNode;
                ArrayList resultList = new ArrayList();
                ArrayList<NodeName> executedNodeNameList = new ArrayList<NodeName>();
                ArrayList<NodeParallelTask> executedNodeList = new ArrayList<NodeParallelTask>();
                for (NodeName nodeName : nodeNameList) {
                    detailNode = (EngineNode)SpringBeanService.getSingleBeanByType(Class.forName(nodeName.getNodeName()));
                    if (!detailNode.couldContinueExecute(engineContext)) continue;
                    NodeParallelTask nodeParallelTask = new NodeParallelTask(detailNode, engineRunData, engineContext);
                    executedNodeList.add(nodeParallelTask);
                    executedNodeNameList.add(nodeName);
                    resultList.add(COMMON_THREAD_POOL_UTIL.getThreadPool().submit(nodeParallelTask));
                }
                for (int i = 0; i < resultList.size(); ++i) {
                    NodeName nodeName;
                    nodeName = (NodeName)executedNodeNameList.get(i);
                    detailNode = (EngineNode)SpringBeanService.getSingleBeanByType(Class.forName(nodeName.getNodeName()));
                    NodeConf nodeConf = nodeMap.get(nodeName);
                    boolean strongRely = nodeConf.isStrongRely();
                    int timeout = nodeConf.getTimeout();
                    Future future = (Future)resultList.get(i);
                    try {
                        Object o = future.get(timeout, TimeUnit.MILLISECONDS);
                        engineContext.getAdaptorMap().put(detailNode.resultKey(), o);
                        continue;
                    }
                    catch (ExecutionException e) {
                        needThrowExp = strongRely;
                        Throwable cause = e.getCause();
                        if (!(cause instanceof BaseException)) continue;
                        if (!strongRely) {
                            log.warn("parallel detailnode occur cexception !!!", (Throwable)e);
                        }
                        exp = (BaseException)cause;
                        continue;
                    }
                    catch (TimeoutException e) {
                        needThrowExp = strongRely;
                        if (!strongRely) {
                            log.warn(String.format("detailEngine execute timeout. nodeName:%s", nodeName));
                        }
                        exp = BaseException.SYSTEM_ERROR;
                        continue;
                    }
                    catch (Exception e) {
                        if (!strongRely) {
                            log.error(String.format("detailEngine execute error. nodeName:%s", nodeName), (Throwable)e);
                        }
                        needThrowExp = strongRely;
                        exp = BaseException.SYSTEM_ERROR;
                    }
                }
            }
            if (!needThrowExp) continue;
            throw exp;
        }
        return this.assembleModel(engineRunData, engineContext);
    }

    private boolean isStrongRely(Map<NodeName, NodeConf> nodeMap, NodeName nodeKey) {
        return nodeMap.get(nodeKey) != null && nodeMap.get(nodeKey).isStrongRely();
    }

    public abstract T assembleModel(EngineRunData var1, EngineContext var2);

    private Map<String, List<NodeName>> groupByGroupName(NodeChain nodeChainChain) {
        LinkedHashMap nodegroup = Maps.newLinkedHashMap();
        for (NodeName nodeKey : nodeChainChain.getNodeList()) {
            List<NodeName> nodeNameList;
            String groupName = nodeKey.getGroupName();
            String nodeName = nodeKey.getNodeName();
            if (StringUtils.isBlank((CharSequence)groupName)) {
                nodeNameList = Lists.newArrayList();
                nodeNameList.add(nodeKey);
                nodegroup.put(nodeName, nodeNameList);
                continue;
            }
            nodeNameList = (List)nodegroup.get(groupName);
            if (nodeNameList == null) {
                nodeNameList = Lists.newArrayList();
            }
            nodeNameList.add(nodeKey);
            nodegroup.put(groupName, nodeNameList);
        }
        return nodegroup;
    }
}

