/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt.security;

import com.google.common.base.Joiner;
import com.luna.common.encrypt.security.SecurityManager;
import com.luna.common.net.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SharingParamManager {
    public static final String CURRENT_DEFAULT_VERSION = "00";
    private static final int MIN_LENGTH = 3;
    private static final int MAX_LENGTH = 4;
    private String version;
    private String[] param;
    private SecurityManager securityManager;

    public SharingParamManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public SharingParamManager(SecurityManager securityManager, String version, String ... param) {
        this.version = version;
        this.param = param;
        this.securityManager = securityManager;
    }

    public SharingParamManager() {
    }

    public String generate() {
        if (ObjectUtils.isEmpty((Object)this.param)) {
            return null;
        }
        String plaintext = Joiner.on((String)"_").join((Object[])this.param);
        String checkSum = this.securityManager.buildCheckSum(plaintext);
        String encrypted = this.securityManager.encrypt(plaintext);
        String body = HttpUtils.urlEncode(encrypted + "-" + checkSum, "UTF-8");
        return body;
    }

    public boolean parse(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return false;
        }
        try {
            String decode = URLDecoder.decode(body, "UTF-8");
            int index = StringUtils.lastIndexOf((CharSequence)decode, (CharSequence)"-");
            if (-1 == index) {
                return false;
            }
            String[] array = new String[]{decode.substring(0, index), decode.substring(index + 1)};
            String decrypted = this.securityManager.decrypt(array[0]);
            String respectiveCheckSum = this.securityManager.buildCheckSum(decrypted);
            if (!respectiveCheckSum.equals(array[1])) {
                return false;
            }
            String[] elements = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)decrypted, (String)"_");
            if (StringUtils.isBlank((CharSequence)this.version)) {
                return false;
            }
            this.setVersion(this.version);
            this.param = elements;
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getParam() {
        return this.param;
    }

    public void setParam(String[] param) {
        this.param = param;
    }
}

