/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.encrypt;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;

public class EncryptUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5Checksum(String md5Prefix, String md5Postfix, String toDigest) {
        try {
            String md5Unid = md5Prefix + toDigest + md5Postfix;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] checksum = md5.digest(md5Unid.getBytes());
            return Integer.toHexString(checksum[0] & 0xFF) + Integer.toHexString(checksum[1] & 0xFF);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String dataEncryptByJdk(String input, String hashType) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(hashType);
            byte[] inputByteArray = input.getBytes(StandardCharsets.UTF_8);
            messageDigest.update(inputByteArray);
            byte[] resultByteArray = messageDigest.digest();
            return EncryptUtils.byteArrayToHex(resultByteArray);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileEncryptByJdk(String path, String hashType) {
        try {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                FileInputStream in = new FileInputStream(path);
                return EncryptUtils.streamEncryptByJdk(in, hashType);
            }
            return null;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String streamEncryptByJdk(InputStream in, String hashType) {
        try {
            MessageDigest messagedigest = MessageDigest.getInstance(hashType);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                messagedigest.update(buffer, 0, read);
            }
            in.close();
            return EncryptUtils.byteArrayToHex(messagedigest.digest());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static String encryptByCommonIo(InputStream in, String hashType) {
        try {
            switch (hashType) {
                case "sha256": {
                    return DigestUtils.sha256Hex((InputStream)in);
                }
                case "md5": {
                    return DigestUtils.md5Hex((InputStream)in);
                }
                case "md2": {
                    return DigestUtils.md2Hex((InputStream)in);
                }
                case "sha512": {
                    return DigestUtils.sha512Hex((InputStream)in);
                }
                case "sha384": {
                    return DigestUtils.sha384Hex((InputStream)in);
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptByCommonIo(String data, String hashType) {
        switch (hashType) {
            case "SHA-256": {
                return DigestUtils.sha256Hex((String)data);
            }
            case "MD5": {
                return DigestUtils.md5Hex((String)data);
            }
            case "MD2": {
                return DigestUtils.md2Hex((String)data);
            }
            case "SHA-512": {
                return DigestUtils.sha512Hex((String)data);
            }
            case "SHA-384": {
                return DigestUtils.sha384Hex((String)data);
            }
        }
        return null;
    }
}

