/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.check;

import com.luna.common.dto.constant.ResultEnum;
import com.luna.common.exception.BaseException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preconditions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Preconditions.class);

    public static void check(boolean expression, ResultEnum error) {
        if (!expression) {
            throw new BaseException(error.getErrorCode(), error.getErrorMsg());
        }
    }

    public static void checkExpression(boolean expression, String msg) {
        if (!expression) {
            throw new BaseException(ResultEnum.PARAMETER_INVALID.getErrorCode(), msg);
        }
    }

    public static void checkExpression(boolean expression, ResultEnum resultEnum) {
        if (!expression) {
            throw new BaseException(resultEnum.getErrorCode(), resultEnum.getErrorMsg());
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new BaseException(ResultEnum.PARAMETER_INVALID.getErrorCode(), errorMessage);
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, ResultEnum bizErrorEnum) {
        if (reference == null) {
            throw new BaseException(bizErrorEnum.getErrorCode(), bizErrorEnum.getErrorMsg());
        }
        return reference;
    }

    public static <T> T checkParamNotNull(T reference) {
        if (reference == null) {
            throw new BaseException(ResultEnum.PARAMETER_INVALID.getErrorCode(), ResultEnum.PARAMETER_INVALID.getErrorMsg());
        }
        return reference;
    }

    public static void triggerException(String message) {
        throw new BaseException(ResultEnum.PARAMETER_INVALID.getErrorCode(), message);
    }
}

