/*
 * Decompiled with CFR 0.152.
 */
package com.luna.common.calendarist.core;

import com.luna.common.calendarist.base.ConvertFromType;

public abstract class CalendaristBase {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int TIMEMILLIS = 15;
    public static final int LEAP_MONTH_OF_CURRENT = 21;
    public static final int LEAP_MONTH = 22;
    protected ConvertFromType from;
    protected int[] fields = new int[25];

    protected static void validate(int year, int month, int day, int hour, int minute, int second, int millis) {
        if (year < 1900 || year > 2100) {
            throw new IllegalArgumentException("the argument 'year' must between 1900 and 2100");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("the argument 'month' must between 1 and 12");
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("the argument 'day' must between 1 and 31");
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("the argument 'hour' must between 0 and 23");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("the argument 'minute' must between 0 and 59");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("the argument 'second' must between 0 and 59");
        }
        if (millis < 0 || millis > 999) {
            throw new IllegalArgumentException("the argument 'millis' must between 0 and 999");
        }
    }

    public void set(int field, int value) {
        this.validateSet(field, value);
        this.fields[field] = value;
    }

    public void setFrom(ConvertFromType from) {
        this.from = from;
    }

    public void itsLeapMonth(boolean itsLeapMonth) {
        this.fields[21] = itsLeapMonth ? 1 : 0;
    }

    private void validateSet(int field, int value) {
        if (field == 1 && (value < 1900 || value > 2100)) {
            throw new IllegalArgumentException("the argument 'year' must between 1900 and 2100");
        }
        if (field == 2 && (value < 1 || value > 12)) {
            throw new IllegalArgumentException("the argument 'month' must between 1 and 12");
        }
        if (field == 5 && (value < 1 || value > 31)) {
            throw new IllegalArgumentException("the argument 'day' must between 1 and 31");
        }
        if (field == 11 && (value < 0 || value > 23)) {
            throw new IllegalArgumentException("the argument 'hour' must between 0 and 23");
        }
        if (field == 12 && (value < 0 || value > 59)) {
            throw new IllegalArgumentException("the argument 'minute' must between 0 and 59");
        }
        if (field == 13 && (value < 0 || value > 59)) {
            throw new IllegalArgumentException("the argument 'second' must between 0 and 59");
        }
        if (field == 14 && (value < 0 || value > 999)) {
            throw new IllegalArgumentException("the argument 'millis' must between 0 and 999");
        }
    }
}

