/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.content.Context;
import android.graphics.ColorFilter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.UCropDevelopConfig;
import java.util.List;

public class UCropGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<String> list;
    private int currentSelectPosition;
    private OnItemClickListener listener;

    public UCropGalleryAdapter(List<String> list) {
        this.list = list;
    }

    public void setCurrentSelectPosition(int currentSelectPosition) {
        this.currentSelectPosition = currentSelectPosition;
    }

    public int getCurrentSelectPosition() {
        return this.currentSelectPosition;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int position) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ucrop_gallery_adapter_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        ColorFilter colorFilter;
        String path = this.list.get(position);
        if (UCropDevelopConfig.imageEngine != null) {
            UCropDevelopConfig.imageEngine.loadImage(holder.itemView.getContext(), path, holder.mIvPhoto);
        }
        if (this.currentSelectPosition == position) {
            holder.mViewCurrentSelect.setVisibility(0);
            colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)holder.itemView.getContext(), (int)R.color.ucrop_color_80), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
        } else {
            colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)holder.itemView.getContext(), (int)R.color.ucrop_color_20), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
            holder.mViewCurrentSelect.setVisibility(8);
        }
        holder.mIvPhoto.setColorFilter(colorFilter);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UCropGalleryAdapter.this.listener != null) {
                    UCropGalleryAdapter.this.listener.onItemClick(holder.getAbsoluteAdapterPosition(), v);
                }
            }
        });
    }

    public int getItemCount() {
        return this.list != null ? this.list.size() : 0;
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, View var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mIvPhoto;
        View mViewCurrentSelect;

        public ViewHolder(View view) {
            super(view);
            this.mIvPhoto = (ImageView)view.findViewById(R.id.iv_photo);
            this.mViewCurrentSelect = view.findViewById(R.id.view_current_select);
        }
    }
}

