/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.luck.picture.lib.R;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.player.AbsController;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.utils.DateUtils;

public class VideoController
extends ConstraintLayout
implements AbsController {
    private SeekBar seekBar;
    private ImageView ivPlay;
    private TextView tvDuration;
    private TextView tvCurrentDuration;
    private IMediaPlayer mediaPlayer;
    private AbsController.OnPlayStateListener playStateListener;
    private SeekBar.OnSeekBarChangeListener seekBarChangeListener;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final TickerRunnable mTickerRunnable = new TickerRunnable();

    public long getMaxUpdateIntervalDuration() {
        return 1000L;
    }

    public long getMinCurrentPosition() {
        return 1000L;
    }

    public VideoController(@NonNull Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        VideoController.inflate((Context)this.getContext(), (int)R.layout.ps_video_controller, (ViewGroup)this);
        this.seekBar = (SeekBar)this.findViewById(R.id.seek_bar);
        this.ivPlay = (ImageView)this.findViewById(R.id.iv_play_video);
        this.tvDuration = (TextView)this.findViewById(R.id.tv_total_duration);
        this.tvCurrentDuration = (TextView)this.findViewById(R.id.tv_current_time);
        this.tvDuration.setText((CharSequence)"00:00");
        this.tvCurrentDuration.setText((CharSequence)"00:00");
        this.initWidget();
    }

    public void initWidget() {
    }

    @Override
    @Nullable
    public ImageView getViewPlay() {
        return this.ivPlay;
    }

    @Override
    @Nullable
    public SeekBar getSeekBar() {
        return this.seekBar;
    }

    @Override
    @Nullable
    public ImageView getFast() {
        return null;
    }

    @Override
    @Nullable
    public ImageView getBack() {
        return null;
    }

    @Override
    @Nullable
    public TextView getTvDuration() {
        return this.tvDuration;
    }

    @Override
    @Nullable
    public TextView getTvCurrentDuration() {
        return this.tvCurrentDuration;
    }

    @Override
    public void setDataSource(LocalMedia media) {
        this.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(media.getDuration(), false));
        this.seekBar.setMax((int)media.getDuration());
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    seekBar.setProgress(progress);
                    VideoController.this.tvCurrentDuration.setText((CharSequence)DateUtils.formatDurationTime(progress, false));
                    if (VideoController.this.mediaPlayer.isPlaying()) {
                        VideoController.this.mediaPlayer.seekTo(progress);
                    }
                }
                if (VideoController.this.seekBarChangeListener != null) {
                    VideoController.this.seekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (VideoController.this.seekBarChangeListener != null) {
                    VideoController.this.seekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (VideoController.this.seekBarChangeListener != null) {
                    VideoController.this.seekBarChangeListener.onStopTrackingTouch(seekBar);
                }
            }
        });
        this.ivPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoController.this.dispatchPlay();
            }
        });
    }

    public void dispatchPlay() {
        if (this.mediaPlayer.isPlaying()) {
            if (this.playStateListener != null) {
                this.playStateListener.onPlayState(false);
            }
            this.mediaPlayer.pause();
            this.stop(false);
        } else {
            if (this.playStateListener != null) {
                this.playStateListener.onPlayState(true);
            }
            this.mediaPlayer.resume();
            this.start();
        }
    }

    @Override
    public void setIMediaPlayer(IMediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    @Override
    public void start() {
        this.mHandler.post((Runnable)this.mTickerRunnable);
        this.ivPlay.setImageResource(R.drawable.ps_ic_action_pause);
    }

    @Override
    public void stop(boolean isReset) {
        this.mHandler.removeCallbacks((Runnable)this.mTickerRunnable);
        this.ivPlay.setImageResource(R.drawable.ps_ic_action_play);
        if (isReset) {
            this.tvCurrentDuration.setText((CharSequence)"00:00");
            this.seekBar.setProgress(0);
        }
    }

    @Override
    public void setOnPlayStateListener(AbsController.OnPlayStateListener l) {
        this.playStateListener = l;
    }

    @Override
    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener l) {
        this.seekBarChangeListener = l;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacks((Runnable)this.mTickerRunnable);
    }

    private class TickerRunnable
    implements Runnable {
        private TickerRunnable() {
        }

        @Override
        public void run() {
            long duration = VideoController.this.mediaPlayer.getDuration();
            long currentPosition = VideoController.this.mediaPlayer.getCurrentPosition();
            String time = DateUtils.formatDurationTime(currentPosition, false);
            if (!TextUtils.equals((CharSequence)time, (CharSequence)VideoController.this.tvCurrentDuration.getText())) {
                VideoController.this.tvCurrentDuration.setText((CharSequence)time);
                if (duration - currentPosition > VideoController.this.getMinCurrentPosition()) {
                    VideoController.this.seekBar.setProgress((int)currentPosition);
                } else {
                    VideoController.this.seekBar.setProgress((int)duration);
                }
            }
            VideoController.this.mHandler.postDelayed((Runnable)this, VideoController.this.getMaxUpdateIntervalDuration() - currentPosition % VideoController.this.getMaxUpdateIntervalDuration());
        }
    }
}

