/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.player.IMediaPlayer;

public class AudioMediaPlayer
implements IMediaPlayer {
    private MediaPlayer mediaPlayer = null;

    @Override
    public void initMediaPlayer() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
    }

    @Override
    public void setDataSource(Context context, String path, boolean isLoopAutoPlay) {
        try {
            if (PictureMimeType.isContent(path)) {
                this.mediaPlayer.setDataSource(context, Uri.parse((String)path));
            } else {
                this.mediaPlayer.setDataSource(path);
            }
            this.mediaPlayer.setLooping(isLoopAutoPlay);
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        return this.mediaPlayer != null ? (long)this.mediaPlayer.getCurrentPosition() : 0L;
    }

    @Override
    public long getDuration() {
        return this.mediaPlayer != null ? (long)this.mediaPlayer.getDuration() : 0L;
    }

    @Override
    public void seekTo(int speed) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(speed);
        }
    }

    @Override
    public void start() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    @Override
    public void resume() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    @Override
    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.mediaPlayer != null && this.mediaPlayer.isPlaying();
    }

    @Override
    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    @Override
    public void reset() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.reset();
        }
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    @Override
    public void setOnInfoListener(IMediaPlayer.OnInfoListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnInfoListener((mp, what, extra) -> {
                listener.onInfo(this, what, extra);
                return false;
            });
        } else {
            this.mediaPlayer.setOnInfoListener(null);
        }
    }

    @Override
    public void setOnErrorListener(IMediaPlayer.OnErrorListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnErrorListener((mp, what, extra) -> {
                listener.onError(this, what, extra);
                return false;
            });
        } else {
            this.mediaPlayer.setOnErrorListener(null);
        }
    }

    @Override
    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnPreparedListener(mp -> listener.onPrepared(this));
        } else {
            this.mediaPlayer.setOnPreparedListener(null);
        }
    }

    @Override
    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener listener) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (listener != null) {
            this.mediaPlayer.setOnCompletionListener(mp -> listener.onCompletion(this));
        } else {
            this.mediaPlayer.setOnCompletionListener(null);
        }
    }

    @Override
    public void setOnVideoSizeChangedListener(IMediaPlayer.OnVideoSizeChangedListener listener) {
    }
}

