/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.engine.MediaPlayerEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.player.AbsController;
import com.luck.picture.lib.player.DefaultMediaPlayerEngine;
import com.luck.picture.lib.player.IMediaPlayer;
import com.luck.picture.lib.utils.IntentUtils;

public class PreviewVideoHolder
extends BasePreviewHolder {
    public ImageView ivPlayButton;
    public ProgressBar progress;
    public boolean isPlayed = false;
    public IMediaPlayer mediaPlayer;
    public AbsController controller;
    public final Handler handler = new Handler(Looper.getMainLooper());
    private final AbsController.OnPlayStateListener playStateListener = new AbsController.OnPlayStateListener(){

        @Override
        public void onPlayState(boolean isPlaying) {
            if (isPlaying) {
                PreviewVideoHolder.this.ivPlayButton.setVisibility(8);
            } else {
                PreviewVideoHolder.this.ivPlayButton.setVisibility(0);
            }
        }
    };
    private final SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            PreviewVideoHolder.this.stopControllerHandler();
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            if (PreviewVideoHolder.this.controller != null && ((View)PreviewVideoHolder.this.controller).getAlpha() == 1.0f) {
                PreviewVideoHolder.this.startControllerHandler();
            }
        }
    };

    public PreviewVideoHolder(@NonNull View itemView) {
        super(itemView);
        this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
        this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
        MediaPlayerEngine videoPlayerEngine = this.selectorConfig.videoPlayerEngine != null ? this.selectorConfig.videoPlayerEngine : new DefaultMediaPlayerEngine();
        this.mediaPlayer = videoPlayerEngine.onCreateMediaPlayer(itemView.getContext());
        this.controller = videoPlayerEngine.onCreatePlayerController(itemView.getContext());
        this.attachComponent((ViewGroup)itemView);
    }

    public void attachComponent(ViewGroup group) {
        if (this.mediaPlayer instanceof View) {
            View player = (View)this.mediaPlayer;
            ViewParent playerParent = player.getParent();
            if (playerParent instanceof ViewGroup) {
                ((ViewGroup)playerParent).removeView(player);
            }
            group.addView(player, 0);
            if (this.controller != null) {
                group.addView((View)this.controller);
            }
        }
    }

    @Override
    protected void findViews(View itemView) {
    }

    @Override
    protected void loadImage(LocalMedia media, int maxWidth, int maxHeight) {
        if (this.selectorConfig.imageEngine != null) {
            String availablePath = media.getAvailablePath();
            if (maxWidth == -1 && maxHeight == -1) {
                this.selectorConfig.imageEngine.loadImage(this.itemView.getContext(), availablePath, (ImageView)this.coverImageView);
            } else {
                this.selectorConfig.imageEngine.loadImage(this.itemView.getContext(), (ImageView)this.coverImageView, availablePath, maxWidth, maxHeight);
            }
        }
    }

    @Override
    protected void onClickBackPressed() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void onLongPressDownload(final LocalMedia media) {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    @Override
    public void bindData(final LocalMedia media, int position) {
        super.bindData(media, position);
        if (this.controller != null) {
            ((View)this.controller).setAlpha(0.0f);
            this.controller.setDataSource(media);
            this.controller.setIMediaPlayer(this.mediaPlayer);
            this.controller.setOnPlayStateListener(this.playStateListener);
            this.controller.setOnSeekBarChangeListener(this.seekBarChangeListener);
        }
        this.setScaleDisplaySize(media);
        this.ivPlayButton.setVisibility(this.selectorConfig.isPreviewZoomEffect ? 8 : 0);
        this.ivPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PreviewVideoHolder.this.dispatchPlay(media.getAvailablePath(), media.getFileName());
                PreviewVideoHolder.this.showVideoController();
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewVideoHolder.this.selectorConfig.isPauseResumePlay) {
                    PreviewVideoHolder.this.dispatchPlay(media.getAvailablePath(), media.getFileName());
                    PreviewVideoHolder.this.showVideoController();
                } else if (PreviewVideoHolder.this.controller != null && ((View)PreviewVideoHolder.this.controller).getAlpha() == 0.0f) {
                    PreviewVideoHolder.this.showVideoController();
                } else if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    public void startControllerHandler() {
        this.stopControllerHandler();
        if (this.mediaPlayer.getDuration() > this.disappearControllerDuration()) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PreviewVideoHolder.this.handler.removeCallbacks((Runnable)this);
                    ((View)PreviewVideoHolder.this.controller).animate().alpha(0.0f).setDuration(220L).start();
                }
            }, this.disappearControllerDuration().longValue());
        }
    }

    public void stopControllerHandler() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void hideVideoController() {
        if (this.controller != null) {
            ((View)this.controller).animate().alpha(0.0f).setDuration(80L).start();
        }
    }

    public Long disappearControllerDuration() {
        return 3000L;
    }

    public void dispatchPlay(String path, String displayName) {
        if (this.selectorConfig.isUseSystemVideoPlayer) {
            IntentUtils.startSystemPlayerVideo(this.itemView.getContext(), this.media.getAvailablePath());
        } else if (this.isPlayed) {
            if (this.mediaPlayer.isPlaying()) {
                this.mediaPlayer.pause();
                if (this.controller != null) {
                    this.controller.stop(false);
                }
                this.ivPlayButton.setVisibility(0);
                this.setPreviewVideoTitle(null);
            } else {
                this.mediaPlayer.resume();
                if (this.controller != null) {
                    this.controller.start();
                }
                this.ivPlayButton.setVisibility(8);
                this.setPreviewVideoTitle(displayName);
            }
        } else {
            this.onPlayingLoading();
            this.setPreviewVideoTitle(displayName);
            this.mediaPlayer.setDataSource(this.itemView.getContext(), path, this.selectorConfig.isLoopAutoPlay);
            this.isPlayed = true;
        }
    }

    public void setPreviewVideoTitle(String title) {
        if (this.mPreviewEventListener != null) {
            this.mPreviewEventListener.onPreviewVideoTitle(title);
        }
    }

    @Override
    protected void setScaleDisplaySize(LocalMedia media) {
        super.setScaleDisplaySize(media);
        if (!this.selectorConfig.isPreviewZoomEffect && this.screenWidth < this.screenHeight) {
            ViewGroup.LayoutParams layoutParams = ((View)this.mediaPlayer).getLayoutParams();
            if (layoutParams instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams playerLayoutParams = (FrameLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.gravity = 17;
            } else if (layoutParams instanceof RelativeLayout.LayoutParams) {
                RelativeLayout.LayoutParams playerLayoutParams = (RelativeLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.addRule(13);
            } else if (layoutParams instanceof LinearLayout.LayoutParams) {
                LinearLayout.LayoutParams playerLayoutParams = (LinearLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.gravity = 17;
            } else if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ConstraintLayout.LayoutParams playerLayoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.topToTop = 0;
                playerLayoutParams.bottomToBottom = 0;
            }
        }
    }

    public void onPlayingLoading() {
        this.progress.setVisibility(0);
        this.ivPlayButton.setVisibility(8);
    }

    public void onPlayingVideoState() {
        this.coverImageView.setVisibility(8);
        this.ivPlayButton.setVisibility(8);
        this.progress.setVisibility(8);
        this.showVideoController();
        if (this.controller != null) {
            this.controller.start();
        }
    }

    public void onDefaultVideoState() {
        this.setPreviewVideoTitle(null);
        this.coverImageView.setVisibility(0);
        this.ivPlayButton.setVisibility(0);
        this.progress.setVisibility(8);
        this.hideVideoController();
        if (this.controller != null) {
            this.controller.stop(true);
        }
        this.isPlayed = false;
    }

    public void showVideoController() {
        if (this.controller != null && this.mediaPlayer.isPlaying() && ((View)this.controller).getAlpha() == 0.0f) {
            ((View)this.controller).animate().alpha(1.0f).setDuration(300L).start();
            this.startControllerHandler();
        }
    }

    @Override
    public void onViewAttachedToWindow() {
        this.mediaPlayer.initMediaPlayer();
        this.mediaPlayer.setOnVideoSizeChangedListener(new IMediaPlayer.OnVideoSizeChangedListener(){

            @Override
            public void onVideoSizeChanged(IMediaPlayer mp, int width, int height) {
            }
        });
        this.mediaPlayer.setOnInfoListener(new IMediaPlayer.OnInfoListener(){

            @Override
            public boolean onInfo(IMediaPlayer mp, int what, int extra) {
                return false;
            }
        });
        this.mediaPlayer.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(){

            @Override
            public void onPrepared(IMediaPlayer mp) {
                mp.start();
                PreviewVideoHolder.this.onPlayingVideoState();
            }
        });
        this.mediaPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(){

            @Override
            public void onCompletion(IMediaPlayer mp) {
                mp.stop();
                mp.reset();
                PreviewVideoHolder.this.onDefaultVideoState();
            }
        });
        this.mediaPlayer.setOnErrorListener(new IMediaPlayer.OnErrorListener(){

            @Override
            public void onError(IMediaPlayer mp, int what, int extra) {
                PreviewVideoHolder.this.onDefaultVideoState();
            }
        });
    }

    @Override
    public void onViewDetachedFromWindow() {
        this.release();
    }

    @Override
    public void release() {
        this.mediaPlayer.setOnInfoListener(null);
        this.mediaPlayer.setOnErrorListener(null);
        this.mediaPlayer.setOnPreparedListener(null);
        this.mediaPlayer.setOnCompletionListener(null);
        this.mediaPlayer.setOnVideoSizeChangedListener(null);
        this.mediaPlayer.release();
        if (this.controller != null) {
            this.controller.setOnPlayStateListener(null);
            this.controller.setOnSeekBarChangeListener(null);
        }
        this.stopControllerHandler();
        this.onDefaultVideoState();
    }
}

