/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.SandboxFileLoader;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import java.util.ArrayList;
import java.util.List;

public final class LocalMediaLoader
extends IBridgeMediaLoader {
    public LocalMediaLoader(Context context, SelectorConfig config) {
        super(context, config);
    }

    private static String getSelectionArgsForVideoMediaCondition(String durationCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + durationCondition;
    }

    private static String getSelectionArgsForAudioMediaCondition(String durationCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + durationCondition;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryImageMimeType, String queryVideoMimeType) {
        return "(media_type=?" + queryImageMimeType + " OR " + "media_type" + "=?" + queryVideoMimeType + " AND " + timeCondition + ") AND " + sizeCondition;
    }

    private static String getSelectionArgsForImageMediaCondition(String fileSizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + fileSizeCondition;
    }

    @Override
    public void loadAllAlbum(final OnQueryAllAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                Cursor data = LocalMediaLoader.this.getContext().getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, LocalMediaLoader.this.getSelection(), LocalMediaLoader.this.getSelectionArgs(), LocalMediaLoader.this.getSortOrder());
                try {
                    if (data != null) {
                        LocalMediaFolder allImageFolder = new LocalMediaFolder();
                        ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                        int count = data.getCount();
                        if (count > 0) {
                            data.moveToFirst();
                            do {
                                LocalMedia media;
                                if ((media = LocalMediaLoader.this.parseLocalMedia(data, false)) == null) continue;
                                LocalMediaFolder folder = LocalMediaLoader.this.getImageFolder(media.getPath(), media.getMimeType(), media.getParentFolderName(), imageFolders);
                                folder.setBucketId(media.getBucketId());
                                folder.getData().add(media);
                                folder.setFolderTotalNum(folder.getFolderTotalNum() + 1);
                                folder.setBucketId(media.getBucketId());
                                latelyImages.add(media);
                                int imageNum = allImageFolder.getFolderTotalNum();
                                allImageFolder.setFolderTotalNum(imageNum + 1);
                            } while (data.moveToNext());
                            LocalMediaFolder selfFolder = SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.getContext(), LocalMediaLoader.this.getConfig().sandboxDir);
                            if (selfFolder != null) {
                                imageFolders.add(selfFolder);
                                allImageFolder.setFolderTotalNum(allImageFolder.getFolderTotalNum() + selfFolder.getFolderTotalNum());
                                allImageFolder.setData(selfFolder.getData());
                                latelyImages.addAll(0, selfFolder.getData());
                                if (60 > selfFolder.getFolderTotalNum()) {
                                    if (latelyImages.size() > 60) {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages.subList(0, 60));
                                    } else {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages);
                                    }
                                }
                            }
                            if (latelyImages.size() > 0) {
                                SortUtils.sortFolder(imageFolders);
                                imageFolders.add(0, allImageFolder);
                                allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                                allImageFolder.setFirstMimeType(((LocalMedia)latelyImages.get(0)).getMimeType());
                                String folderName = TextUtils.isEmpty((CharSequence)LocalMediaLoader.this.getConfig().defaultAlbumName) ? (LocalMediaLoader.this.getConfig().chooseMode == SelectMimeType.ofAudio() ? LocalMediaLoader.this.getContext().getString(R.string.ps_all_audio) : LocalMediaLoader.this.getContext().getString(R.string.ps_camera_roll)) : LocalMediaLoader.this.getConfig().defaultAlbumName;
                                allImageFolder.setFolderName(folderName);
                                allImageFolder.setBucketId(-1L);
                                allImageFolder.setData(latelyImages);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return imageFolders;
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadOnlyInAppDirAllMedia(final OnQueryAlbumListener<LocalMediaFolder> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMediaFolder>(){

            @Override
            public LocalMediaFolder doInBackground() {
                return SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.getContext(), LocalMediaLoader.this.getConfig().sandboxDir);
            }

            @Override
            public void onSuccess(LocalMediaFolder result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadPageMediaData(long bucketId, int page, int pageSize, OnQueryDataResultListener<LocalMedia> query) {
    }

    @Override
    public String getAlbumFirstCover(long bucketId) {
        return null;
    }

    @Override
    protected String getSelection() {
        String durationCondition = this.getDurationCondition();
        String fileSizeCondition = this.getFileSizeCondition();
        switch (this.getConfig().chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(durationCondition, fileSizeCondition, this.getImageMimeTypeCondition(), this.getVideoMimeTypeCondition());
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForImageMediaCondition(fileSizeCondition, this.getImageMimeTypeCondition());
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForVideoMediaCondition(durationCondition, this.getVideoMimeTypeCondition());
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForAudioMediaCondition(durationCondition, this.getAudioMimeTypeCondition());
            }
        }
        return null;
    }

    @Override
    protected String[] getSelectionArgs() {
        switch (this.getConfig().chooseMode) {
            case 0: {
                return new String[]{String.valueOf(1), String.valueOf(3)};
            }
            case 1: {
                return new String[]{String.valueOf(1)};
            }
            case 2: {
                return new String[]{String.valueOf(3)};
            }
            case 3: {
                return new String[]{String.valueOf(2)};
            }
        }
        return null;
    }

    @Override
    protected String getSortOrder() {
        return TextUtils.isEmpty((CharSequence)this.getConfig().sortOrder) ? "date_modified DESC" : this.getConfig().sortOrder;
    }

    @Override
    protected LocalMedia parseLocalMedia(Cursor data, boolean isUsePool) {
        int idColumn = data.getColumnIndexOrThrow(PROJECTION[0]);
        int dataColumn = data.getColumnIndexOrThrow(PROJECTION[1]);
        int mimeTypeColumn = data.getColumnIndexOrThrow(PROJECTION[2]);
        int widthColumn = data.getColumnIndexOrThrow(PROJECTION[3]);
        int heightColumn = data.getColumnIndexOrThrow(PROJECTION[4]);
        int durationColumn = data.getColumnIndexOrThrow(PROJECTION[5]);
        int sizeColumn = data.getColumnIndexOrThrow(PROJECTION[6]);
        int folderNameColumn = data.getColumnIndexOrThrow(PROJECTION[7]);
        int fileNameColumn = data.getColumnIndexOrThrow(PROJECTION[8]);
        int bucketIdColumn = data.getColumnIndexOrThrow(PROJECTION[9]);
        int dateAddedColumn = data.getColumnIndexOrThrow(PROJECTION[10]);
        int orientationColumn = data.getColumnIndexOrThrow(PROJECTION[11]);
        long id2 = data.getLong(idColumn);
        long dateAdded = data.getLong(dateAddedColumn);
        String mimeType = data.getString(mimeTypeColumn);
        String absolutePath = data.getString(dataColumn);
        String url = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : absolutePath;
        String string2 = mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
        if (mimeType.endsWith("image/*")) {
            mimeType = MediaUtils.getMimeTypeFromMediaUrl(absolutePath);
            if (!this.getConfig().isGif && PictureMimeType.isHasGif(mimeType)) {
                return null;
            }
        }
        if (mimeType.endsWith("image/*")) {
            return null;
        }
        if (!this.getConfig().isWebp && mimeType.startsWith(PictureMimeType.ofWEBP())) {
            return null;
        }
        if (!this.getConfig().isBmp && PictureMimeType.isHasBmp(mimeType)) {
            return null;
        }
        if (!this.getConfig().isHeic && PictureMimeType.isHasHeic(mimeType)) {
            return null;
        }
        int width = data.getInt(widthColumn);
        int height = data.getInt(heightColumn);
        int orientation = data.getInt(orientationColumn);
        if (orientation == 90 || orientation == 270) {
            width = data.getInt(heightColumn);
            height = data.getInt(widthColumn);
        }
        long duration = data.getLong(durationColumn);
        long size = data.getLong(sizeColumn);
        String folderName = data.getString(folderNameColumn);
        String fileName = data.getString(fileNameColumn);
        long bucketId = data.getLong(bucketIdColumn);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = PictureMimeType.getUrlToFileName(absolutePath);
        }
        if (this.getConfig().isFilterSizeDuration && size > 0L && size < 1024L) {
            return null;
        }
        if (PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) {
            if (this.getConfig().filterVideoMinSecond > 0 && duration < (long)this.getConfig().filterVideoMinSecond) {
                return null;
            }
            if (this.getConfig().filterVideoMaxSecond > 0 && duration > (long)this.getConfig().filterVideoMaxSecond) {
                return null;
            }
            if (this.getConfig().isFilterSizeDuration && duration <= 0L) {
                return null;
            }
        }
        LocalMedia media = LocalMedia.create();
        media.setId(id2);
        media.setBucketId(bucketId);
        media.setPath(url);
        media.setRealPath(absolutePath);
        media.setFileName(fileName);
        media.setParentFolderName(folderName);
        media.setDuration(duration);
        media.setChooseModel(this.getConfig().chooseMode);
        media.setMimeType(mimeType);
        media.setWidth(width);
        media.setHeight(height);
        media.setSize(size);
        media.setDateAddedTime(dateAdded);
        if (this.mConfig.onQueryFilterListener != null && this.mConfig.onQueryFilterListener.onFilter(media)) {
            return null;
        }
        return media;
    }

    private LocalMediaFolder getImageFolder(String firstPath, String firstMimeType, String folderName, List<LocalMediaFolder> imageFolders) {
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getFolderName();
            if (TextUtils.isEmpty((CharSequence)name) || !TextUtils.equals((CharSequence)name, (CharSequence)folderName)) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setFolderName(folderName);
        newFolder.setFirstImagePath(firstPath);
        newFolder.setFirstMimeType(firstMimeType);
        imageFolders.add(newFolder);
        return newFolder;
    }
}

