/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import java.util.List;
import java.util.Locale;

public abstract class IBridgeMediaLoader {
    protected static final String TAG = IBridgeMediaLoader.class.getSimpleName();
    protected static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    protected static final String ORDER_BY = "date_modified DESC";
    protected static final String NOT_GIF = " AND (mime_type!='image/gif')";
    protected static final String NOT_WEBP = " AND (mime_type!='image/webp')";
    protected static final String NOT_BMP = " AND (mime_type!='image/bmp')";
    protected static final String NOT_XMS_BMP = " AND (mime_type!='image/x-ms-bmp')";
    protected static final String NOT_VND_WAP_BMP = " AND (mime_type!='image/vnd.wap.wbmp')";
    protected static final String NOT_HEIC = " AND (mime_type!='image/heic')";
    protected static final String GROUP_BY_BUCKET_Id = " GROUP BY (bucket_id";
    protected static final String DISTINCT_BUCKET_Id = "DISTINCT bucket_id";
    protected static final String COLUMN_COUNT = "count";
    protected static final String COLUMN_BUCKET_ID = "bucket_id";
    protected static final String COLUMN_DURATION = "duration";
    protected static final String COLUMN_BUCKET_DISPLAY_NAME = "bucket_display_name";
    protected static final String COLUMN_ORIENTATION = "orientation";
    protected static final int MAX_SORT_SIZE = 60;
    private final Context mContext;
    protected final SelectorConfig mConfig;
    protected static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added", "orientation"};
    protected static final String[] ALL_PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added", "orientation", "COUNT(*) AS count"};

    public IBridgeMediaLoader(Context context, SelectorConfig config) {
        this.mContext = context;
        this.mConfig = config;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected SelectorConfig getConfig() {
        return this.mConfig;
    }

    public abstract String getAlbumFirstCover(long var1);

    public abstract void loadAllAlbum(OnQueryAllAlbumListener<LocalMediaFolder> var1);

    public abstract void loadPageMediaData(long var1, int var3, int var4, OnQueryDataResultListener<LocalMedia> var5);

    public abstract void loadOnlyInAppDirAllMedia(OnQueryAlbumListener<LocalMediaFolder> var1);

    protected abstract String getSelection();

    protected abstract String[] getSelectionArgs();

    protected abstract String getSortOrder();

    protected abstract LocalMedia parseLocalMedia(Cursor var1, boolean var2);

    protected String getDurationCondition() {
        long maxS = this.getConfig().filterVideoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.getConfig().filterVideoMaxSecond;
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(0L, (long)this.getConfig().filterVideoMinSecond), "=", maxS);
    }

    protected String getFileSizeCondition() {
        long maxS = this.getConfig().filterMaxFileSize == 0L ? Long.MAX_VALUE : this.getConfig().filterMaxFileSize;
        return String.format(Locale.CHINA, "%d <%s _size and _size <= %d", Math.max(0L, this.getConfig().filterMinFileSize), "=", maxS);
    }

    protected String getImageMimeTypeCondition() {
        List<String> filters = this.getConfig().queryOnlyImageList;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            String mimeType = filters.get(i);
            stringBuilder.append(i == 0 ? " AND " : " OR ").append("mime_type").append("='").append(mimeType).append("'");
        }
        if (!this.getConfig().isGif && !this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofGIF())) {
            stringBuilder.append(NOT_GIF);
        }
        if (!this.getConfig().isWebp && !this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofWEBP())) {
            stringBuilder.append(NOT_WEBP);
        }
        if (!(this.getConfig().isBmp || this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofBMP()) || this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofXmsBMP()) || this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofWapBMP()))) {
            stringBuilder.append(NOT_BMP).append(NOT_XMS_BMP).append(NOT_VND_WAP_BMP);
        }
        if (!this.getConfig().isHeic && !this.getConfig().queryOnlyImageList.contains(PictureMimeType.ofHeic())) {
            stringBuilder.append(NOT_HEIC);
        }
        return stringBuilder.toString();
    }

    protected String getVideoMimeTypeCondition() {
        List<String> filters = this.getConfig().queryOnlyVideoList;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            String mimeType = filters.get(i);
            stringBuilder.append(i == 0 ? " AND " : " OR ").append("mime_type").append("='").append(mimeType).append("'");
        }
        return stringBuilder.toString();
    }

    protected String getAudioMimeTypeCondition() {
        List<String> filters = this.getConfig().queryOnlyAudioList;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            String mimeType = filters.get(i);
            stringBuilder.append(i == 0 ? " AND " : " OR ").append("mime_type").append("='").append(mimeType).append("'");
        }
        return stringBuilder.toString();
    }
}

