/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.engine.MediaPlayerEngine;
import com.luck.picture.lib.engine.VideoPlayerEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnPlayerListener;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.utils.IntentUtils;

public class PreviewVideoHolder
extends BasePreviewHolder {
    public ImageView ivPlayButton;
    public ProgressBar progress;
    public View videoPlayer;
    private boolean isPlayed = false;
    private final OnPlayerListener mPlayerListener = new OnPlayerListener(){

        @Override
        public void onPlayerError() {
            PreviewVideoHolder.this.playerDefaultUI();
        }

        @Override
        public void onPlayerReady() {
            PreviewVideoHolder.this.playerIngUI();
        }

        @Override
        public void onPlayerLoading() {
            PreviewVideoHolder.this.progress.setVisibility(0);
        }

        @Override
        public void onPlayerEnd() {
            PreviewVideoHolder.this.playerDefaultUI();
        }
    };

    public PreviewVideoHolder(@NonNull View itemView) {
        super(itemView);
        ViewGroup viewGroup;
        this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
        this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
        this.ivPlayButton.setVisibility(this.selectorConfig.isPreviewZoomEffect ? 8 : 0);
        if (this.selectorConfig.videoPlayerEngine == null) {
            this.selectorConfig.videoPlayerEngine = new MediaPlayerEngine();
        }
        this.videoPlayer = this.selectorConfig.videoPlayerEngine.onCreateVideoPlayer(itemView.getContext());
        if (this.videoPlayer == null) {
            throw new NullPointerException("onCreateVideoPlayer cannot be empty,Please implement " + VideoPlayerEngine.class);
        }
        if (this.videoPlayer.getLayoutParams() == null) {
            this.videoPlayer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        if ((viewGroup = (ViewGroup)itemView).indexOfChild(this.videoPlayer) != -1) {
            viewGroup.removeView(this.videoPlayer);
        }
        viewGroup.addView(this.videoPlayer, 0);
        this.videoPlayer.setVisibility(8);
    }

    @Override
    protected void findViews(View itemView) {
    }

    @Override
    protected void loadImage(LocalMedia media, int maxWidth, int maxHeight) {
        if (this.selectorConfig.imageEngine != null) {
            String availablePath = media.getAvailablePath();
            if (maxWidth == -1 && maxHeight == -1) {
                this.selectorConfig.imageEngine.loadImage(this.itemView.getContext(), availablePath, (ImageView)this.coverImageView);
            } else {
                this.selectorConfig.imageEngine.loadImage(this.itemView.getContext(), (ImageView)this.coverImageView, availablePath, maxWidth, maxHeight);
            }
        }
    }

    @Override
    protected void onClickBackPressed() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void onLongPressDownload(final LocalMedia media) {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    @Override
    public void bindData(LocalMedia media, int position) {
        super.bindData(media, position);
        this.setScaleDisplaySize(media);
        this.ivPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewVideoHolder.this.selectorConfig.isPauseResumePlay) {
                    PreviewVideoHolder.this.dispatchPlay();
                } else {
                    PreviewVideoHolder.this.startPlay();
                }
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewVideoHolder.this.selectorConfig.isPauseResumePlay) {
                    PreviewVideoHolder.this.dispatchPlay();
                } else if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    private void dispatchPlay() {
        if (this.isPlayed) {
            if (this.isPlaying()) {
                this.onPause();
            } else {
                this.onResume();
            }
        } else {
            this.startPlay();
        }
    }

    private void onResume() {
        this.ivPlayButton.setVisibility(8);
        if (this.selectorConfig.videoPlayerEngine != null) {
            this.selectorConfig.videoPlayerEngine.onResume(this.videoPlayer);
        }
    }

    public void onPause() {
        this.ivPlayButton.setVisibility(0);
        if (this.selectorConfig.videoPlayerEngine != null) {
            this.selectorConfig.videoPlayerEngine.onPause(this.videoPlayer);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.selectorConfig.videoPlayerEngine != null && this.selectorConfig.videoPlayerEngine.isPlaying(this.videoPlayer);
    }

    public void startPlay() {
        if (this.selectorConfig.isUseSystemVideoPlayer) {
            IntentUtils.startSystemPlayerVideo(this.itemView.getContext(), this.media.getAvailablePath());
        } else {
            if (this.videoPlayer == null) {
                throw new NullPointerException("VideoPlayer cannot be empty,Please implement " + VideoPlayerEngine.class);
            }
            if (this.selectorConfig.videoPlayerEngine != null) {
                this.progress.setVisibility(0);
                this.ivPlayButton.setVisibility(8);
                this.mPreviewEventListener.onPreviewVideoTitle(this.media.getFileName());
                this.isPlayed = true;
                this.selectorConfig.videoPlayerEngine.onStarPlayer(this.videoPlayer, this.media);
            }
        }
    }

    @Override
    protected void setScaleDisplaySize(LocalMedia media) {
        super.setScaleDisplaySize(media);
        if (!this.selectorConfig.isPreviewZoomEffect && this.screenWidth < this.screenHeight) {
            ViewGroup.LayoutParams layoutParams = this.videoPlayer.getLayoutParams();
            if (layoutParams instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams playerLayoutParams = (FrameLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.gravity = 17;
            } else if (layoutParams instanceof RelativeLayout.LayoutParams) {
                RelativeLayout.LayoutParams playerLayoutParams = (RelativeLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.addRule(13);
            } else if (layoutParams instanceof LinearLayout.LayoutParams) {
                LinearLayout.LayoutParams playerLayoutParams = (LinearLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.gravity = 17;
            } else if (layoutParams instanceof ConstraintLayout.LayoutParams) {
                ConstraintLayout.LayoutParams playerLayoutParams = (ConstraintLayout.LayoutParams)layoutParams;
                playerLayoutParams.width = this.screenWidth;
                playerLayoutParams.height = this.screenAppInHeight;
                playerLayoutParams.topToTop = 0;
                playerLayoutParams.bottomToBottom = 0;
            }
        }
    }

    private void playerDefaultUI() {
        this.isPlayed = false;
        this.ivPlayButton.setVisibility(0);
        this.progress.setVisibility(8);
        this.coverImageView.setVisibility(0);
        this.videoPlayer.setVisibility(8);
        if (this.mPreviewEventListener != null) {
            this.mPreviewEventListener.onPreviewVideoTitle(null);
        }
    }

    private void playerIngUI() {
        this.progress.setVisibility(8);
        this.ivPlayButton.setVisibility(8);
        this.coverImageView.setVisibility(8);
        this.videoPlayer.setVisibility(0);
    }

    @Override
    public void onViewAttachedToWindow() {
        if (this.selectorConfig.videoPlayerEngine != null) {
            this.selectorConfig.videoPlayerEngine.onPlayerAttachedToWindow(this.videoPlayer);
            this.selectorConfig.videoPlayerEngine.addPlayListener(this.mPlayerListener);
        }
    }

    @Override
    public void onViewDetachedFromWindow() {
        if (this.selectorConfig.videoPlayerEngine != null) {
            this.selectorConfig.videoPlayerEngine.onPlayerDetachedFromWindow(this.videoPlayer);
            this.selectorConfig.videoPlayerEngine.removePlayListener(this.mPlayerListener);
        }
        this.playerDefaultUI();
    }

    @Override
    public void resumePausePlay() {
        if (this.isPlaying()) {
            this.onPause();
        } else {
            this.onResume();
        }
    }

    @Override
    public void release() {
        if (this.selectorConfig.videoPlayerEngine != null) {
            this.selectorConfig.videoPlayerEngine.removePlayListener(this.mPlayerListener);
            this.selectorConfig.videoPlayerEngine.destroy(this.videoPlayer);
        }
    }
}

