/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.PictureOnlyCameraFragment;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.PictureSelectorSystemFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.immersive.ImmersiveManager;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.StyleUtils;
import java.util.ArrayList;

public class PictureSelectorTransparentActivity
extends AppCompatActivity {
    private SelectorConfig selectorConfig;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initSelectorConfig();
        this.immersive();
        this.setContentView(R.layout.ps_empty);
        if (!this.isExternalPreview()) {
            this.setActivitySize();
        }
        this.setupFragment();
    }

    private void initSelectorConfig() {
        this.selectorConfig = SelectorProviders.getInstance().getSelectorConfig();
    }

    private boolean isExternalPreview() {
        int modeTypeSource = this.getIntent().getIntExtra("com.luck.picture.lib.mode_type_source", 0);
        return modeTypeSource == 2;
    }

    private void immersive() {
        if (this.selectorConfig.selectorStyle == null) {
            SelectorProviders.getInstance().getSelectorConfig();
        }
        SelectMainStyle mainStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        int statusBarColor = mainStyle.getStatusBarColor();
        int navigationBarColor = mainStyle.getNavigationBarColor();
        boolean isDarkStatusBarBlack = mainStyle.isDarkStatusBarBlack();
        if (!StyleUtils.checkStyleValidity(statusBarColor)) {
            statusBarColor = ContextCompat.getColor((Context)this, (int)R.color.ps_color_grey);
        }
        if (!StyleUtils.checkStyleValidity(navigationBarColor)) {
            navigationBarColor = ContextCompat.getColor((Context)this, (int)R.color.ps_color_grey);
        }
        ImmersiveManager.immersiveAboveAPI23(this, statusBarColor, navigationBarColor, isDarkStatusBarBlack);
    }

    private void setupFragment() {
        String fragmentTag;
        PictureCommonFragment targetFragment = null;
        int modeTypeSource = this.getIntent().getIntExtra("com.luck.picture.lib.mode_type_source", 0);
        if (modeTypeSource == 1) {
            fragmentTag = PictureSelectorSystemFragment.TAG;
            targetFragment = PictureSelectorSystemFragment.newInstance();
        } else if (modeTypeSource == 2) {
            if (this.selectorConfig.onInjectActivityPreviewListener != null) {
                targetFragment = this.selectorConfig.onInjectActivityPreviewListener.onInjectPreviewFragment();
            }
            if (targetFragment != null) {
                fragmentTag = ((PictureSelectorPreviewFragment)targetFragment).getFragmentTag();
            } else {
                fragmentTag = PictureSelectorPreviewFragment.TAG;
                targetFragment = PictureSelectorPreviewFragment.newInstance();
            }
            int position = this.getIntent().getIntExtra("com.luck.picture.lib.current_preview_position", 0);
            ArrayList<LocalMedia> previewData = new ArrayList<LocalMedia>(this.selectorConfig.selectedPreviewResult);
            boolean isDisplayDelete = this.getIntent().getBooleanExtra("com.luck.picture.lib.external_preview_display_delete", false);
            ((PictureSelectorPreviewFragment)targetFragment).setExternalPreviewData(position, previewData.size(), previewData, isDisplayDelete);
        } else {
            fragmentTag = PictureOnlyCameraFragment.TAG;
            targetFragment = PictureOnlyCameraFragment.newInstance();
        }
        FragmentManager supportFragmentManager = this.getSupportFragmentManager();
        Fragment fragment = supportFragmentManager.findFragmentByTag(fragmentTag);
        if (fragment != null) {
            supportFragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        FragmentInjectManager.injectSystemRoomFragment(supportFragmentManager, fragmentTag, targetFragment);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void setActivitySize() {
        Window window = this.getWindow();
        window.setGravity(51);
        WindowManager.LayoutParams params = window.getAttributes();
        params.x = 0;
        params.y = 0;
        params.height = 1;
        params.width = 1;
        window.setAttributes(params);
    }

    public void finish() {
        super.finish();
        int modeTypeSource = this.getIntent().getIntExtra("com.luck.picture.lib.mode_type_source", 0);
        if (modeTypeSource == 2 && !this.selectorConfig.isPreviewZoomEffect) {
            PictureWindowAnimationStyle windowAnimationStyle = this.selectorConfig.selectorStyle.getWindowAnimationStyle();
            this.overridePendingTransition(0, windowAnimationStyle.activityExitAnimation);
        } else {
            this.overridePendingTransition(0, R.anim.ps_anim_fade_out);
        }
    }
}

