/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BaseRecyclerMediaHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.StyleUtils;

public class ImageViewHolder
extends BaseRecyclerMediaHolder {
    private final ImageView ivEditor;
    private final TextView tvMediaTag;

    public ImageViewHolder(View itemView, SelectorConfig config) {
        super(itemView, config);
        int textColor;
        int textSize;
        int background;
        int[] tagGravity;
        int[] editorGravity;
        this.tvMediaTag = (TextView)itemView.findViewById(R.id.tv_media_tag);
        this.ivEditor = (ImageView)itemView.findViewById(R.id.ivEditor);
        SelectMainStyle adapterStyle = this.selectorConfig.selectorStyle.getSelectMainStyle();
        int imageEditorRes = adapterStyle.getAdapterImageEditorResources();
        if (StyleUtils.checkStyleValidity(imageEditorRes)) {
            this.ivEditor.setImageResource(imageEditorRes);
        }
        if (StyleUtils.checkArrayValidity(editorGravity = adapterStyle.getAdapterImageEditorGravity()) && this.ivEditor.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)this.ivEditor.getLayoutParams()).removeRule(12);
            for (int i : editorGravity) {
                ((RelativeLayout.LayoutParams)this.ivEditor.getLayoutParams()).addRule(i);
            }
        }
        if (StyleUtils.checkArrayValidity(tagGravity = adapterStyle.getAdapterTagGravity()) && this.tvMediaTag.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)this.tvMediaTag.getLayoutParams()).removeRule(21);
            ((RelativeLayout.LayoutParams)this.tvMediaTag.getLayoutParams()).removeRule(12);
            for (int i : tagGravity) {
                ((RelativeLayout.LayoutParams)this.tvMediaTag.getLayoutParams()).addRule(i);
            }
        }
        if (StyleUtils.checkStyleValidity(background = adapterStyle.getAdapterTagBackgroundResources())) {
            this.tvMediaTag.setBackgroundResource(background);
        }
        if (StyleUtils.checkSizeValidity(textSize = adapterStyle.getAdapterTagTextSize())) {
            this.tvMediaTag.setTextSize((float)textSize);
        }
        if (StyleUtils.checkStyleValidity(textColor = adapterStyle.getAdapterTagTextColor())) {
            this.tvMediaTag.setTextColor(textColor);
        }
    }

    @Override
    public void bindData(LocalMedia media, int position) {
        super.bindData(media, position);
        if (media.isEditorImage() && media.isCut()) {
            this.ivEditor.setVisibility(0);
        } else {
            this.ivEditor.setVisibility(8);
        }
        this.tvMediaTag.setVisibility(0);
        if (PictureMimeType.isHasGif(media.getMimeType())) {
            this.tvMediaTag.setText((CharSequence)this.mContext.getString(R.string.ps_gif_tag));
        } else if (PictureMimeType.isHasWebp(media.getMimeType())) {
            this.tvMediaTag.setText((CharSequence)this.mContext.getString(R.string.ps_webp_tag));
        } else if (MediaUtils.isLongImage(media.getWidth(), media.getHeight())) {
            this.tvMediaTag.setText((CharSequence)this.mContext.getString(R.string.ps_long_chart));
        } else {
            this.tvMediaTag.setVisibility(8);
        }
    }
}

