/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.entity.MediaData;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.SandboxFileLoader;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class LocalMediaPageLoader
extends IBridgeMediaLoader {
    private String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryMimeTypeOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeTypeOptions).append(" OR ").append("media_type").append("=? AND ").append(timeCondition).append(") AND ").append(sizeCondition);
        if (this.isWithAllQuery()) {
            return stringBuilder.toString();
        }
        return stringBuilder.append(")").append(" GROUP BY (bucket_id").toString();
    }

    private String getSelectionArgsForImageMediaCondition(String fileSizeCondition, String queryMimeTypeOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isWithAllQuery()) {
            return stringBuilder.append("media_type").append("=?").append(queryMimeTypeOptions).append(" AND ").append(fileSizeCondition).toString();
        }
        return stringBuilder.append("(").append("media_type").append("=?").append(queryMimeTypeOptions).append(") AND ").append(fileSizeCondition).append(")").append(" GROUP BY (bucket_id").toString();
    }

    private String getSelectionArgsForVideoMediaCondition(String durationCondition, String queryMimeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isWithAllQuery()) {
            return stringBuilder.append("media_type").append("=?").append(queryMimeCondition).append(" AND ").append(durationCondition).toString();
        }
        return stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(") AND ").append(durationCondition).append(")").append(" GROUP BY (bucket_id").toString();
    }

    private String getSelectionArgsForAudioMediaCondition(String durationCondition, String queryMimeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isWithAllQuery()) {
            return stringBuilder.append("media_type").append("=?").append(queryMimeCondition).append(" AND ").append(durationCondition).toString();
        }
        return stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(") AND ").append(durationCondition).append(")").append(" GROUP BY (bucket_id").toString();
    }

    private static String[] getSelectionArgsForPageSingleMediaType(int mediaType, long bucketId) {
        String[] stringArray;
        if (bucketId == -1L) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(mediaType);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = String.valueOf(mediaType);
            stringArray = stringArray3;
            stringArray3[1] = ValueOf.toString(bucketId);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlbumFirstCover(long bucketId) {
        Cursor data = null;
        try {
            if (SdkVersionUtils.isR()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), 1, 0, this.getSortOrder());
                data = this.getContext().getContentResolver().query(QUERY_URI, new String[]{"_id", "mime_type", "_data"}, queryArgs, null);
            } else {
                String orderBy = this.getSortOrder() + " limit 1 offset 0";
                data = this.getContext().getContentResolver().query(QUERY_URI, new String[]{"_id", "mime_type", "_data"}, this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), orderBy);
            }
            if (data != null && data.getCount() > 0) {
                if (data.moveToFirst()) {
                    long id2 = data.getLong(data.getColumnIndexOrThrow("_id"));
                    String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                    String string2 = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : data.getString(data.getColumnIndexOrThrow("_data"));
                    return string2;
                }
                String id2 = null;
                return id2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (data != null && !data.isClosed()) {
                data.close();
            }
        }
        return null;
    }

    @Override
    public void loadPageMediaData(final long bucketId, final int page, final int pageSize, final OnQueryDataResultListener<LocalMedia> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<MediaData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaData doInBackground() {
                Cursor data = null;
                try {
                    if (SdkVersionUtils.isR()) {
                        Bundle queryArgs = MediaUtils.createQueryArgsBundle(LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), pageSize, (page - 1) * pageSize, LocalMediaPageLoader.this.getSortOrder());
                        data = LocalMediaPageLoader.this.getContext().getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, queryArgs, null);
                    } else {
                        String orderBy = page == -1 ? LocalMediaPageLoader.this.getSortOrder() : LocalMediaPageLoader.this.getSortOrder() + " limit " + pageSize + " offset " + (page - 1) * pageSize;
                        data = LocalMediaPageLoader.this.getContext().getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), orderBy);
                    }
                    if (data != null) {
                        ArrayList<LocalMedia> list;
                        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                        if (data.getCount() > 0) {
                            data.moveToFirst();
                            do {
                                LocalMedia media;
                                if ((media = LocalMediaPageLoader.this.parseLocalMedia(data, false)) == null) continue;
                                result.add(media);
                            } while (data.moveToNext());
                        }
                        if (bucketId == -1L && page == 1 && (list = SandboxFileLoader.loadInAppSandboxFile(LocalMediaPageLoader.this.getContext(), LocalMediaPageLoader.this.getConfig().sandboxDir)) != null) {
                            result.addAll(list);
                            SortUtils.sortLocalMediaAddedTime(result);
                        }
                        MediaData mediaData = new MediaData(data.getCount() > 0, result);
                        return mediaData;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)IBridgeMediaLoader.TAG, (String)("loadMedia Page Data Error: " + e.getMessage()));
                    MediaData mediaData = new MediaData();
                    return mediaData;
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return new MediaData();
            }

            @Override
            public void onSuccess(MediaData result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onComplete(result.data != null ? result.data : new ArrayList(), result.isHasNextMore);
                }
            }
        });
    }

    @Override
    public void loadOnlyInAppDirAllMedia(final OnQueryAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMediaFolder>(){

            @Override
            public LocalMediaFolder doInBackground() {
                return SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaPageLoader.this.getContext(), LocalMediaPageLoader.this.getConfig().sandboxDir);
            }

            @Override
            public void onSuccess(LocalMediaFolder result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadAllAlbum(final OnQueryAllAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                Cursor data = LocalMediaPageLoader.this.getContext().getContentResolver().query(IBridgeMediaLoader.QUERY_URI, LocalMediaPageLoader.this.isWithAllQuery() ? IBridgeMediaLoader.PROJECTION : IBridgeMediaLoader.ALL_PROJECTION, LocalMediaPageLoader.this.getSelection(), LocalMediaPageLoader.this.getSelectionArgs(), LocalMediaPageLoader.this.getSortOrder());
                try {
                    if (data != null) {
                        int count = data.getCount();
                        int totalCount = 0;
                        ArrayList<LocalMediaFolder> mediaFolders = new ArrayList<LocalMediaFolder>();
                        if (count > 0) {
                            Object firstImagePath;
                            if (LocalMediaPageLoader.this.isWithAllQuery()) {
                                HashMap<Long, Long> countMap = new HashMap<Long, Long>();
                                HashSet<Long> hashSet = new HashSet<Long>();
                                while (data.moveToNext()) {
                                    long bucketId;
                                    Long newCount;
                                    if (LocalMediaPageLoader.this.getConfig().isPageSyncAsCount) {
                                        LocalMedia media = LocalMediaPageLoader.this.parseLocalMedia(data, true);
                                        if (media == null) continue;
                                        media.recycle();
                                    }
                                    if ((newCount = (Long)countMap.get(bucketId = data.getLong(data.getColumnIndexOrThrow("bucket_id")))) == null) {
                                        newCount = 1L;
                                    } else {
                                        Long l = newCount;
                                        Long l2 = newCount = Long.valueOf(newCount + 1L);
                                    }
                                    countMap.put(bucketId, newCount);
                                    if (hashSet.contains(bucketId)) continue;
                                    LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                    mediaFolder.setBucketId(bucketId);
                                    String bucketDisplayName = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
                                    String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                                    if (!countMap.containsKey(bucketId)) continue;
                                    long size = (Long)countMap.get(bucketId);
                                    long id2 = data.getLong(data.getColumnIndexOrThrow("_id"));
                                    mediaFolder.setFolderName(bucketDisplayName);
                                    mediaFolder.setFolderTotalNum(ValueOf.toInt(size));
                                    mediaFolder.setFirstImagePath(MediaUtils.getRealPathUri(id2, mimeType));
                                    mediaFolder.setFirstMimeType(mimeType);
                                    mediaFolders.add(mediaFolder);
                                    hashSet.add(bucketId);
                                }
                                for (LocalMediaFolder mediaFolder : mediaFolders) {
                                    int size = ValueOf.toInt(countMap.get(mediaFolder.getBucketId()));
                                    mediaFolder.setFolderTotalNum(size);
                                    totalCount += size;
                                }
                            } else {
                                data.moveToFirst();
                                do {
                                    String url = data.getString(data.getColumnIndexOrThrow("_data"));
                                    String bucketDisplayName = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
                                    String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                                    long bucketId = data.getLong(data.getColumnIndexOrThrow("bucket_id"));
                                    int size = data.getInt(data.getColumnIndexOrThrow("count"));
                                    LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                    mediaFolder.setBucketId(bucketId);
                                    mediaFolder.setFirstImagePath(url);
                                    mediaFolder.setFolderName(bucketDisplayName);
                                    mediaFolder.setFirstMimeType(mimeType);
                                    mediaFolder.setFolderTotalNum(size);
                                    mediaFolders.add(mediaFolder);
                                    totalCount += size;
                                } while (data.moveToNext());
                            }
                            LocalMediaFolder allMediaFolder = new LocalMediaFolder();
                            LocalMediaFolder selfFolder = SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaPageLoader.this.getContext(), LocalMediaPageLoader.this.getConfig().sandboxDir);
                            if (selfFolder != null) {
                                mediaFolders.add(selfFolder);
                                firstImagePath = selfFolder.getFirstImagePath();
                                File file = new File((String)firstImagePath);
                                long lastModified = file.lastModified();
                                totalCount += selfFolder.getFolderTotalNum();
                                allMediaFolder.setData(new ArrayList<LocalMedia>());
                                if (data.moveToFirst()) {
                                    long lastModified2;
                                    allMediaFolder.setFirstImagePath(SdkVersionUtils.isQ() ? LocalMediaPageLoader.getFirstUri(data) : LocalMediaPageLoader.getFirstUrl(data));
                                    allMediaFolder.setFirstMimeType(LocalMediaPageLoader.getFirstCoverMimeType(data));
                                    if (PictureMimeType.isContent(allMediaFolder.getFirstImagePath())) {
                                        String path = PictureFileUtils.getPath(LocalMediaPageLoader.this.getContext(), Uri.parse((String)allMediaFolder.getFirstImagePath()));
                                        lastModified2 = new File(path).lastModified();
                                    } else {
                                        lastModified2 = new File(allMediaFolder.getFirstImagePath()).lastModified();
                                    }
                                    if (lastModified > lastModified2) {
                                        allMediaFolder.setFirstImagePath(selfFolder.getFirstImagePath());
                                        allMediaFolder.setFirstMimeType(selfFolder.getFirstMimeType());
                                    }
                                }
                            } else if (data.moveToFirst()) {
                                allMediaFolder.setFirstImagePath(SdkVersionUtils.isQ() ? LocalMediaPageLoader.getFirstUri(data) : LocalMediaPageLoader.getFirstUrl(data));
                                allMediaFolder.setFirstMimeType(LocalMediaPageLoader.getFirstCoverMimeType(data));
                            }
                            if (totalCount == 0) {
                                firstImagePath = mediaFolders;
                                return firstImagePath;
                            }
                            SortUtils.sortFolder(mediaFolders);
                            allMediaFolder.setFolderTotalNum(totalCount);
                            allMediaFolder.setBucketId(-1L);
                            String folderName = TextUtils.isEmpty((CharSequence)LocalMediaPageLoader.this.getConfig().defaultAlbumName) ? (LocalMediaPageLoader.this.getConfig().chooseMode == SelectMimeType.ofAudio() ? LocalMediaPageLoader.this.getContext().getString(R.string.ps_all_audio) : LocalMediaPageLoader.this.getContext().getString(R.string.ps_camera_roll)) : LocalMediaPageLoader.this.getConfig().defaultAlbumName;
                            allMediaFolder.setFolderName(folderName);
                            mediaFolders.add(0, allMediaFolder);
                            if (LocalMediaPageLoader.this.getConfig().isSyncCover && LocalMediaPageLoader.this.getConfig().chooseMode == SelectMimeType.ofAll()) {
                                LocalMediaPageLoader.this.synchronousFirstCover(mediaFolders);
                            }
                            ArrayList<LocalMediaFolder> arrayList = mediaFolders;
                            return arrayList;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)IBridgeMediaLoader.TAG, (String)("loadAllMedia Data Error: " + e.getMessage()));
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return new ArrayList<LocalMediaFolder>();
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                LocalMedia.destroyPool();
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    private void synchronousFirstCover(List<LocalMediaFolder> mediaFolders) {
        for (int i = 0; i < mediaFolders.size(); ++i) {
            String firstCover;
            LocalMediaFolder mediaFolder = mediaFolders.get(i);
            if (mediaFolder == null || TextUtils.isEmpty((CharSequence)(firstCover = this.getAlbumFirstCover(mediaFolder.getBucketId())))) continue;
            mediaFolder.setFirstImagePath(firstCover);
        }
    }

    private static String getFirstUri(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
        String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
        return MediaUtils.getRealPathUri(id2, mimeType);
    }

    private static String getFirstCoverMimeType(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
    }

    private static String getFirstUrl(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("_data"));
    }

    private String getPageSelection(long bucketId) {
        String durationCondition = this.getDurationCondition();
        String sizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.getConfig().chooseMode) {
            case 0: {
                return LocalMediaPageLoader.getPageSelectionArgsForAllMediaCondition(bucketId, queryMimeCondition, durationCondition, sizeCondition);
            }
            case 1: {
                return LocalMediaPageLoader.getPageSelectionArgsForImageMediaCondition(bucketId, queryMimeCondition, sizeCondition);
            }
            case 2: {
                return LocalMediaPageLoader.getPageSelectionArgsForVideoMediaCondition(bucketId, queryMimeCondition, durationCondition, sizeCondition);
            }
            case 3: {
                return LocalMediaPageLoader.getPageSelectionArgsForAudioMediaCondition(bucketId, queryMimeCondition, durationCondition, sizeCondition);
            }
        }
        return null;
    }

    private static String getPageSelectionArgsForAllMediaCondition(long bucketId, String queryMimeCondition, String durationCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" OR ").append("media_type").append("=? AND ").append(durationCondition).append(") AND ");
        if (bucketId == -1L) {
            return stringBuilder.append(sizeCondition).toString();
        }
        return stringBuilder.append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private static String getPageSelectionArgsForImageMediaCondition(long bucketId, String queryMimeCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?");
        if (bucketId == -1L) {
            return stringBuilder.append(queryMimeCondition).append(") AND ").append(sizeCondition).toString();
        }
        return stringBuilder.append(queryMimeCondition).append(") AND ").append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private static String getPageSelectionArgsForVideoMediaCondition(long bucketId, String queryMimeCondition, String durationCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" AND ").append(durationCondition).append(") AND ");
        if (bucketId == -1L) {
            return stringBuilder.append(sizeCondition).toString();
        }
        return stringBuilder.append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private static String getPageSelectionArgsForAudioMediaCondition(long bucketId, String queryMimeCondition, String durationCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" AND ").append(durationCondition).append(") AND ");
        if (bucketId == -1L) {
            return stringBuilder.append(sizeCondition).toString();
        }
        return stringBuilder.append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private String[] getPageSelectionArgs(long bucketId) {
        switch (this.getConfig().chooseMode) {
            case 0: {
                if (bucketId == -1L) {
                    return new String[]{String.valueOf(1), String.valueOf(3)};
                }
                return new String[]{String.valueOf(1), String.valueOf(3), ValueOf.toString(bucketId)};
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(1, bucketId);
            }
            case 2: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(3, bucketId);
            }
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(2, bucketId);
            }
        }
        return null;
    }

    @Override
    protected String getSelection() {
        String durationCondition = this.getDurationCondition();
        String fileSizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.getConfig().chooseMode) {
            case 0: {
                return this.getSelectionArgsForAllMediaCondition(durationCondition, fileSizeCondition, queryMimeCondition);
            }
            case 1: {
                return this.getSelectionArgsForImageMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 2: {
                return this.getSelectionArgsForVideoMediaCondition(durationCondition, queryMimeCondition);
            }
            case 3: {
                return this.getSelectionArgsForAudioMediaCondition(durationCondition, queryMimeCondition);
            }
        }
        return null;
    }

    @Override
    protected String[] getSelectionArgs() {
        switch (this.getConfig().chooseMode) {
            case 0: {
                return new String[]{String.valueOf(1), String.valueOf(3)};
            }
            case 1: {
                return new String[]{String.valueOf(1)};
            }
            case 2: {
                return new String[]{String.valueOf(3)};
            }
            case 3: {
                return new String[]{String.valueOf(2)};
            }
        }
        return null;
    }

    @Override
    protected String getSortOrder() {
        return TextUtils.isEmpty((CharSequence)this.getConfig().sortOrder) ? "date_modified DESC" : this.getConfig().sortOrder;
    }

    private boolean isWithAllQuery() {
        if (SdkVersionUtils.isQ()) {
            return true;
        }
        return this.getConfig().isPageSyncAsCount;
    }

    @Override
    protected LocalMedia parseLocalMedia(Cursor data, boolean isUsePool) {
        int idColumn = data.getColumnIndexOrThrow(PROJECTION[0]);
        int dataColumn = data.getColumnIndexOrThrow(PROJECTION[1]);
        int mimeTypeColumn = data.getColumnIndexOrThrow(PROJECTION[2]);
        int widthColumn = data.getColumnIndexOrThrow(PROJECTION[3]);
        int heightColumn = data.getColumnIndexOrThrow(PROJECTION[4]);
        int durationColumn = data.getColumnIndexOrThrow(PROJECTION[5]);
        int sizeColumn = data.getColumnIndexOrThrow(PROJECTION[6]);
        int folderNameColumn = data.getColumnIndexOrThrow(PROJECTION[7]);
        int fileNameColumn = data.getColumnIndexOrThrow(PROJECTION[8]);
        int bucketIdColumn = data.getColumnIndexOrThrow(PROJECTION[9]);
        int dateAddedColumn = data.getColumnIndexOrThrow(PROJECTION[10]);
        int orientationColumn = data.getColumnIndexOrThrow(PROJECTION[11]);
        long id2 = data.getLong(idColumn);
        String mimeType = data.getString(mimeTypeColumn);
        String absolutePath = data.getString(dataColumn);
        String url = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : absolutePath;
        String string2 = mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
        if (this.getConfig().isFilterInvalidFile && (PictureMimeType.isHasImage(mimeType) ? !TextUtils.isEmpty((CharSequence)absolutePath) && !PictureFileUtils.isImageFileExists(absolutePath) : !PictureFileUtils.isFileExists(absolutePath))) {
            return null;
        }
        if (mimeType.endsWith("image/*")) {
            mimeType = MediaUtils.getMimeTypeFromMediaUrl(absolutePath);
            if (!this.getConfig().isGif && PictureMimeType.isHasGif(mimeType)) {
                return null;
            }
        }
        if (mimeType.endsWith("image/*")) {
            return null;
        }
        if (!this.getConfig().isWebp && mimeType.startsWith(PictureMimeType.ofWEBP())) {
            return null;
        }
        if (!this.getConfig().isBmp && PictureMimeType.isHasBmp(mimeType)) {
            return null;
        }
        int width = data.getInt(widthColumn);
        int height = data.getInt(heightColumn);
        int orientation = data.getInt(orientationColumn);
        if (orientation == 90 || orientation == 270) {
            width = data.getInt(heightColumn);
            height = data.getInt(widthColumn);
        }
        long duration = data.getLong(durationColumn);
        long size = data.getLong(sizeColumn);
        String folderName = data.getString(folderNameColumn);
        String fileName = data.getString(fileNameColumn);
        long bucketId = data.getLong(bucketIdColumn);
        long dateAdded = data.getLong(dateAddedColumn);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = PictureMimeType.getUrlToFileName(absolutePath);
        }
        if (this.getConfig().isFilterSizeDuration && size > 0L && size < 1024L) {
            return null;
        }
        if (PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) {
            if (this.getConfig().filterVideoMinSecond > 0 && duration < (long)this.getConfig().filterVideoMinSecond) {
                return null;
            }
            if (this.getConfig().filterVideoMaxSecond > 0 && duration > (long)this.getConfig().filterVideoMaxSecond) {
                return null;
            }
            if (this.getConfig().isFilterSizeDuration && duration <= 0L) {
                return null;
            }
        }
        LocalMedia media = isUsePool ? LocalMedia.obtain() : LocalMedia.create();
        media.setId(id2);
        media.setBucketId(bucketId);
        media.setPath(url);
        media.setRealPath(absolutePath);
        media.setFileName(fileName);
        media.setParentFolderName(folderName);
        media.setDuration(duration);
        media.setChooseModel(this.getConfig().chooseMode);
        media.setMimeType(mimeType);
        media.setWidth(width);
        media.setHeight(height);
        media.setSize(size);
        media.setDateAddedTime(dateAdded);
        if (PictureSelectionConfig.onQueryFilterListener != null && PictureSelectionConfig.onQueryFilterListener.onFilter(media)) {
            return null;
        }
        return media;
    }
}

